/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.backend;

import org.eclipse.fx.drift.Vec2i;
import org.eclipse.fx.drift.internal.GL;
import org.eclipse.fx.drift.internal.backend.Image;
import org.eclipse.fx.drift.internal.common.IOSurfaceImageData;
import org.eclipse.fx.drift.internal.common.ImageData;
import org.eclipse.fx.drift.internal.jni.macos.MacOS;

public class IOSurfaceImage
implements Image {
    public static final Image.ImageType TYPE = new Image.ImageType("IOSurface");
    private int number;
    private Vec2i size;
    private IOSurfaceImageData data;
    int glTexture;
    private MacOS.IOSurfaceRef ioSurface;
    private long ioSurfaceID;

    public IOSurfaceImage(int number, Vec2i size) {
        this.number = number;
        this.size = size;
    }

    @Override
    public ImageData getData() {
        return this.data;
    }

    @Override
    public int getGLTexture() {
        return this.glTexture;
    }

    @Override
    public void allocate() {
        this.ioSurface = MacOS.createIOSurface(this.size.x, this.size.y);
        this.glTexture = GL.glGenTexture();
        this.ioSurfaceID = MacOS.IOSurfaceGetID(this.ioSurface);
        GL.glBindTexture(34037, this.glTexture);
        MacOS.CGLContextObj cglContext = MacOS.CGLGetCurrentContext();
        MacOS.CGLError success = MacOS.CGLTexImageIOSurface2D(cglContext, 34037, 6408, this.size.x, this.size.y, 32993, 33639, this.ioSurface, 0);
        if (success != MacOS.CGLError.kCGLNoError) {
            throw new RuntimeException("CGLError " + (Object)((Object)success));
        }
        GL.glBindTexture(34037, 0);
        this.data = new IOSurfaceImageData(this.number, this.size, this.ioSurfaceID);
    }

    @Override
    public void release() {
        MacOS.CFRelease(this.ioSurface);
        GL.glDeleteTexture(this.glTexture);
    }

    @Override
    public void onAcquire() {
    }

    @Override
    public void onPresent() {
        GL.glFlush();
    }

    public String toString() {
        return TYPE + "Image(" + this.number + ")";
    }
}

