/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import org.eclipse.fx.drift.Placement;
import org.eclipse.fx.drift.impl.DriftDebug;
import org.eclipse.fx.drift.impl.NGDriftFXSurface;
import org.eclipse.fx.drift.internal.DriftFX;
import org.eclipse.fx.drift.internal.DriftLogger;
import org.eclipse.fx.drift.internal.ScreenObserver;
import org.eclipse.fx.drift.internal.SurfaceData;
import org.eclipse.fx.drift.internal.frontend.FrontSwapChain;
import org.eclipse.fx.drift.internal.prism.Prism;

public abstract class BaseDriftFXSurface
extends Node {
    private static final DriftLogger LOGGER = DriftFX.createLogger(BaseDriftFXSurface.class);
    private AtomicReference<SurfaceData> surfaceData = new AtomicReference<Object>(null);
    private final ReadOnlyDoubleWrapper screenScaleFactor = new ReadOnlyDoubleWrapper((Object)this, "screenScaleFactor", 1.0);
    private final DoubleProperty userScaleFactor = new SimpleDoubleProperty((Object)this, "userScaleFactor", 1.0);
    private final ObjectProperty<Placement> placementStrategy = new SimpleObjectProperty((Object)this, "placementStrategy", (Object)Placement.CONTAIN);
    private ScreenObserver screenObserver;
    private double _width;
    private ReadOnlyDoubleWrapper width;
    private double _height;
    private ReadOnlyDoubleWrapper height;
    private AtomicReference<FrontSwapChain> swapChainBuf = new AtomicReference();
    private DoubleProperty minWidth;
    private double _minWidth = -1.0;
    private DoubleProperty minHeight;
    private double _minHeight = -1.0;
    private DoubleProperty prefWidth;
    private double _prefWidth = -1.0;
    private DoubleProperty prefHeight;
    private double _prefHeight = -1.0;
    private DoubleProperty maxWidth;
    private double _maxWidth = -1.0;
    private DoubleProperty maxHeight;
    private double _maxHeight = -1.0;
    private static final CssMetaData<BaseDriftFXSurface, Number> MIN_HEIGHT;
    private static final CssMetaData<BaseDriftFXSurface, Number> PREF_HEIGHT;
    private static final CssMetaData<BaseDriftFXSurface, Number> MAX_HEIGHT;
    private static final CssMetaData<BaseDriftFXSurface, Number> MIN_WIDTH;
    private static final CssMetaData<BaseDriftFXSurface, Number> PREF_WIDTH;
    private static final CssMetaData<BaseDriftFXSurface, Number> MAX_WIDTH;

    protected void init() {
        this.screenObserver = new ScreenObserver(this);
        this.screenScaleFactor.bind((ObservableValue)this.screenObserver.currentRenderScaleProperty());
        this.screenScaleFactor.addListener((x, o, n) -> this.updateSurfaceData());
        this.placementStrategy.addListener((x, o, n) -> this.updateSurfaceData());
    }

    public ReadOnlyDoubleProperty screenScaleFactorProperty() {
        return this.screenScaleFactor.getReadOnlyProperty();
    }

    public double getScreenScaleFactor() {
        return this.screenScaleFactorProperty().get();
    }

    public DoubleProperty userScaleFactorProperty() {
        return this.userScaleFactor;
    }

    public double getUserScaleFactor() {
        return this.userScaleFactorProperty().get();
    }

    public void setUserScaleFactor(double value) {
        this.userScaleFactorProperty().set(value);
    }

    public double minHeight(double width) {
        double override = this.getMinHeight();
        if (override == -1.0) {
            return this.safe(this.computeMinHeight(width));
        }
        if (override == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(width);
        }
        return this.safe(override);
    }

    public double minWidth(double height) {
        double override = this.getMinWidth();
        if (override == -1.0) {
            return this.safe(this.computeMinWidth(height));
        }
        if (override == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(height);
        }
        return this.safe(override);
    }

    public double prefWidth(double height) {
        double override = this.getPrefWidth();
        if (override == -1.0) {
            return this.safe(this.computePrefWidth(height));
        }
        return this.safe(override);
    }

    public double prefHeight(double width) {
        double override = this.getPrefHeight();
        if (override == -1.0) {
            return this.safe(this.computePrefHeight(width));
        }
        return this.safe(override);
    }

    public double maxWidth(double height) {
        double override = this.getMaxWidth();
        if (override == -1.0) {
            return this.safe(this.computeMaxWidth(height));
        }
        if (override == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(height);
        }
        return this.safe(override);
    }

    public double maxHeight(double width) {
        double override = this.getMaxHeight();
        if (override == -1.0) {
            return this.safe(this.computeMaxHeight(width));
        }
        if (override == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(width);
        }
        return this.safe(override);
    }

    private final double safe(double value) {
        return Double.isNaN(value) || value < 0.0 ? 0.0 : value;
    }

    protected double computeMinWidth(double height) {
        return 0.0;
    }

    protected double computeMinHeight(double width) {
        return 0.0;
    }

    protected double computePrefWidth(double height) {
        return this.getLayoutBounds().getWidth();
    }

    protected double computePrefHeight(double width) {
        return this.getLayoutBounds().getHeight();
    }

    protected double computeMaxWidth(double height) {
        return Double.MAX_VALUE;
    }

    protected double computeMaxHeight(double width) {
        return Double.MAX_VALUE;
    }

    private void widthChanged(double value) {
        if (value != this._width) {
            this._width = value;
            this.getHelper().geomChanged();
            this.getHelper().layoutBoundsChanged();
            this.updateSurfaceData();
            this.getHelper().markDirty(DirtyBits.NODE_GEOMETRY);
        }
    }

    public final double getWidth() {
        return this.width == null ? this._width : this.width.get();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        if (this.width == null) {
            this.width = new ReadOnlyDoubleWrapper(this._width){

                protected void invalidated() {
                    BaseDriftFXSurface.this.widthChanged(this.get());
                }

                public Object getBean() {
                    return BaseDriftFXSurface.this;
                }

                public String getName() {
                    return "width";
                }
            };
        }
        return this.width.getReadOnlyProperty();
    }

    protected void setWidth(double value) {
        if (this.width == null) {
            this.widthChanged(value);
        } else {
            this.width.set(value);
        }
    }

    private void heightChanged(double value) {
        if (this._height != value) {
            this._height = value;
            this.getHelper().geomChanged();
            this.getHelper().layoutBoundsChanged();
            this.updateSurfaceData();
            this.getHelper().markDirty(DirtyBits.NODE_GEOMETRY);
        }
    }

    public final double getHeight() {
        return this.height == null ? this._height : this.height.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        if (this.height == null) {
            this.height = new ReadOnlyDoubleWrapper(this._height){

                protected void invalidated() {
                    BaseDriftFXSurface.this.heightChanged(this.get());
                }

                public Object getBean() {
                    return BaseDriftFXSurface.this;
                }

                public String getName() {
                    return "height";
                }
            };
        }
        return this.height.getReadOnlyProperty();
    }

    protected void setHeight(double value) {
        if (this.height == null) {
            this.heightChanged(value);
        } else {
            this.height.set(value);
        }
    }

    private SurfaceData computeSurfaceData() {
        DriftDebug.outputThread();
        return new SurfaceData((float)this.getWidth(), (float)this.getHeight(), (float)this.getScreenScaleFactor(), (float)this.getScreenScaleFactor(), (float)this.getUserScaleFactor(), (float)this.getUserScaleFactor(), 0, this.getPlacementStrategy());
    }

    protected abstract InnerHelper getHelper();

    public void drift_updatePeer() {
        NGDriftFXSurface peer = this.getHelper().getPeer();
        if (this.getHelper().isDirty(DirtyBits.NODE_GEOMETRY)) {
            SurfaceData data = this.surfaceData.get();
            peer.updateSurface(data);
            peer.markDirty();
        }
        if (this.getHelper().isDirty(DirtyBits.NODE_CONTENTS)) {
            FrontSwapChain swapChain = this.swapChainBuf.getAndSet(null);
            if (swapChain != null) {
                peer.setSwapChain(swapChain);
            }
            peer.markDirty();
        }
    }

    public boolean isResizable() {
        return true;
    }

    public void resize(double width, double height) {
        DriftDebug.outputThread();
        this.setWidth(width);
        this.setHeight(height);
        this.updateSurfaceData();
    }

    private void updateSurfaceData() {
        DriftDebug.outputThread();
        SurfaceData data = this.computeSurfaceData();
        if (!data.equals(this.surfaceData.get())) {
            this.surfaceData.set(data);
            this.getHelper().markDirty(DirtyBits.NODE_GEOMETRY);
        }
    }

    public void dirty() {
        DriftDebug.outputThread();
        Platform.runLater(() -> this.getHelper().markDirty(DirtyBits.NODE_CONTENTS));
    }

    public void setSwapChain(FrontSwapChain swapChain) {
        DriftDebug.outputThread();
        FrontSwapChain leftover = this.swapChainBuf.getAndSet(swapChain);
        if (leftover != null) {
            LOGGER.warn(() -> "Leftover swapchain!!! This is not good! " + leftover);
        }
        Platform.runLater(() -> this.getHelper().markDirty(DirtyBits.NODE_CONTENTS));
    }

    private static void drift_addShutdownHook(Runnable hook) {
        Toolkit.getToolkit().addShutdownHook(hook);
    }

    protected BaseBounds drift_computeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        RectBounds rv = new RectBounds(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        rv = tx.transform((BaseBounds)rv, (BaseBounds)rv);
        return rv;
    }

    protected boolean drift_computeContains(double localX, double localY) {
        double w = this.getWidth();
        double h = this.getHeight();
        return w > 0.0 && h > 0.0 && localX >= 0.0 && localY >= 0.0 && localX < w && localY < h;
    }

    protected NGNode drift_createPeer() {
        NGDriftFXSurface peer = new NGDriftFXSurface();
        return peer;
    }

    public final ObjectProperty<Placement> placementStrategyProperty() {
        return this.placementStrategy;
    }

    public final Placement getPlacementStrategy() {
        return (Placement)((Object)this.placementStrategyProperty().get());
    }

    public final void setPlacementStrategy(Placement placementStrategy) {
        this.placementStrategyProperty().set((Object)placementStrategy);
    }

    public final void setMinWidth(double value) {
        if (this.minWidth == null) {
            this._minWidth = value;
            this.requestParentLayout();
        } else {
            this.minWidth.set(value);
        }
    }

    public final double getMinWidth() {
        return this.minWidth == null ? this._minWidth : this.minWidth.get();
    }

    public final DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new MinPrefMaxProperty("minWidth", this._minWidth, MIN_WIDTH);
        }
        return this.minWidth;
    }

    public final void setMinHeight(double value) {
        if (this.minHeight == null) {
            this._minHeight = value;
            this.requestParentLayout();
        } else {
            this.minHeight.set(value);
        }
    }

    public final double getMinHeight() {
        return this.minHeight == null ? this._minHeight : this.minHeight.get();
    }

    public final DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new MinPrefMaxProperty("minHeight", this._minHeight, MIN_HEIGHT);
        }
        return this.minHeight;
    }

    public void setMinSize(double minWidth, double minHeight) {
        this.setMinWidth(minWidth);
        this.setMinHeight(minHeight);
    }

    public final void setPrefWidth(double value) {
        if (this.prefWidth == null) {
            this._prefWidth = value;
            this.requestParentLayout();
        } else {
            this.prefWidth.set(value);
        }
    }

    public final double getPrefWidth() {
        return this.prefWidth == null ? this._prefWidth : this.prefWidth.get();
    }

    public final DoubleProperty prefWidthProperty() {
        if (this.prefWidth == null) {
            this.prefWidth = new MinPrefMaxProperty("prefWidth", this._prefWidth, PREF_WIDTH);
        }
        return this.prefWidth;
    }

    public final void setPrefHeight(double value) {
        if (this.prefHeight == null) {
            this._prefHeight = value;
            this.requestParentLayout();
        } else {
            this.prefHeight.set(value);
        }
    }

    public final double getPrefHeight() {
        return this.prefHeight == null ? this._prefHeight : this.prefHeight.get();
    }

    public final DoubleProperty prefHeightProperty() {
        if (this.prefHeight == null) {
            this.prefHeight = new MinPrefMaxProperty("prefHeight", this._prefHeight, PREF_HEIGHT);
        }
        return this.prefHeight;
    }

    public void setPrefSize(double prefWidth, double prefHeight) {
        this.setPrefWidth(prefWidth);
        this.setPrefHeight(prefHeight);
    }

    public final void setMaxWidth(double value) {
        if (this.maxWidth == null) {
            this._maxWidth = value;
            this.requestParentLayout();
        } else {
            this.maxWidth.set(value);
        }
    }

    public final double getMaxWidth() {
        return this.maxWidth == null ? this._maxWidth : this.maxWidth.get();
    }

    public final DoubleProperty maxWidthProperty() {
        if (this.maxWidth == null) {
            this.maxWidth = new MinPrefMaxProperty("maxWidth", this._maxWidth, MAX_WIDTH);
        }
        return this.maxWidth;
    }

    public final void setMaxHeight(double value) {
        if (this.maxHeight == null) {
            this._maxHeight = value;
            this.requestParentLayout();
        } else {
            this.maxHeight.set(value);
        }
    }

    public final double getMaxHeight() {
        return this.maxHeight == null ? this._maxHeight : this.maxHeight.get();
    }

    public final DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new MinPrefMaxProperty("maxHeight", this._maxHeight, MAX_HEIGHT);
        }
        return this.maxHeight;
    }

    public void setMaxSize(double maxWidth, double maxHeight) {
        this.setMaxWidth(maxWidth);
        this.setMaxHeight(maxHeight);
    }

    protected final void requestParentLayout() {
        Parent p = this.getParent();
        if (p != null) {
            p.requestLayout();
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Arrays.asList(MIN_WIDTH, MIN_HEIGHT, PREF_WIDTH, PREF_HEIGHT, MAX_WIDTH, MAX_HEIGHT);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return BaseDriftFXSurface.getClassCssMetaData();
    }

    static {
        try {
            Prism.initialize();
        }
        catch (Throwable e) {
            LOGGER.error(() -> "Error initializing Prism!", e);
        }
        MIN_HEIGHT = new CssMetaData<BaseDriftFXSurface, Number>("-fx-min-height", StyleConverter.getSizeConverter(), (Number)-1.0){

            public boolean isSettable(BaseDriftFXSurface node) {
                return node.minHeight == null || !node.minHeight.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(BaseDriftFXSurface node) {
                return (StyleableProperty)node.minHeightProperty();
            }
        };
        PREF_HEIGHT = new CssMetaData<BaseDriftFXSurface, Number>("-fx-pref-height", StyleConverter.getSizeConverter(), (Number)-1.0){

            public boolean isSettable(BaseDriftFXSurface node) {
                return node.prefHeight == null || !node.prefHeight.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(BaseDriftFXSurface node) {
                return (StyleableProperty)node.prefHeightProperty();
            }
        };
        MAX_HEIGHT = new CssMetaData<BaseDriftFXSurface, Number>("-fx-max-height", StyleConverter.getSizeConverter(), (Number)-1.0){

            public boolean isSettable(BaseDriftFXSurface node) {
                return node.maxHeight == null || !node.maxHeight.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(BaseDriftFXSurface node) {
                return (StyleableProperty)node.maxHeightProperty();
            }
        };
        MIN_WIDTH = new CssMetaData<BaseDriftFXSurface, Number>("-fx-min-width", StyleConverter.getSizeConverter(), (Number)-1.0){

            public boolean isSettable(BaseDriftFXSurface node) {
                return node.minWidth == null || !node.minWidth.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(BaseDriftFXSurface node) {
                return (StyleableProperty)node.minWidthProperty();
            }
        };
        PREF_WIDTH = new CssMetaData<BaseDriftFXSurface, Number>("-fx-pref-width", StyleConverter.getSizeConverter(), (Number)-1.0){

            public boolean isSettable(BaseDriftFXSurface node) {
                return node.prefWidth == null || !node.prefWidth.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(BaseDriftFXSurface node) {
                return (StyleableProperty)node.prefWidthProperty();
            }
        };
        MAX_WIDTH = new CssMetaData<BaseDriftFXSurface, Number>("-fx-max-width", StyleConverter.getSizeConverter(), (Number)-1.0){

            public boolean isSettable(BaseDriftFXSurface node) {
                return node.maxWidth == null || !node.maxWidth.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(BaseDriftFXSurface node) {
                return (StyleableProperty)node.maxWidthProperty();
            }
        };
    }

    private final class MinPrefMaxProperty
    extends StyleableDoubleProperty {
        private final String name;
        private final CssMetaData<? extends Styleable, Number> cssMetaData;

        MinPrefMaxProperty(String name, double initialValue, CssMetaData<? extends Styleable, Number> cssMetaData) {
            super(initialValue);
            this.name = name;
            this.cssMetaData = cssMetaData;
        }

        public void invalidated() {
            BaseDriftFXSurface.this.requestParentLayout();
        }

        public Object getBean() {
            return BaseDriftFXSurface.this;
        }

        public String getName() {
            return this.name;
        }

        public CssMetaData<? extends Styleable, Number> getCssMetaData() {
            return this.cssMetaData;
        }
    }

    protected static interface InnerHelper {
        public NGDriftFXSurface getPeer();

        public boolean isDirty(DirtyBits var1);

        public void markDirty(DirtyBits var1);

        public void geomChanged();

        public void layoutBoundsChanged();

        public void beginPeerAccess();

        public void endPeerAccess();
    }
}

