/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.jni.macos;

import java.util.Arrays;

public class MacOS {
    private MacOS() {
    }

    public static IOSurfaceRef createIOSurface(int width, int height) {
        long address = MacOS.callCreateIOSurface(width, height);
        if (address == 0L) {
            return null;
        }
        return new IOSurfaceRef(address);
    }

    private static native long callCreateIOSurface(int var0, int var1);

    public static void CFRelease(CFTypeRef typeRef) {
        MacOS.callCFRelease(typeRef.address);
    }

    private static native void callCFRelease(long var0);

    public static long IOSurfaceGetID(IOSurfaceRef ioSurface) {
        return MacOS.callIOSurfaceGetID(ioSurface.address);
    }

    private static native long callIOSurfaceGetID(long var0);

    public static IOSurfaceRef IOSurfaceLookup(long ioSurfaceID) {
        long address = MacOS.callIOSurfaceLookup(ioSurfaceID);
        if (address == 0L) {
            return null;
        }
        return new IOSurfaceRef(address);
    }

    private static native long callIOSurfaceLookup(long var0);

    public static CGLContextObj CGLGetCurrentContext() {
        long address = MacOS.callCGLGetCurrentContext();
        if (address == 0L) {
            return null;
        }
        return new CGLContextObj(address);
    }

    private static native long callCGLGetCurrentContext();

    public static CGLError CGLTexImageIOSurface2D(CGLContextObj ctx, int target, int internal_format, int width, int height, int format, int type, IOSurfaceRef ioSurface, int plane) {
        int error = MacOS.callCGLTexImageIOSurface2D(ctx.address, target, internal_format, width, height, format, type, ioSurface.address, plane);
        return CGLError.fromCode(error);
    }

    private static native int callCGLTexImageIOSurface2D(long var0, int var2, int var3, int var4, int var5, int var6, int var7, long var8, int var10);

    public static native long callGetCGLContextObjFromNSJContext(long var0);

    public static void IOSurfaceLock(IOSurfaceRef ioSurface) {
        MacOS.callIOSurfaceLock(ioSurface.address);
    }

    private static native void callIOSurfaceLock(long var0);

    public static void IOSurfaceUnlock(IOSurfaceRef ioSurface) {
        MacOS.callIOSurfaceUnlock(ioSurface.address);
    }

    private static native void callIOSurfaceUnlock(long var0);

    public static class CGLContextObj {
        public final long address;

        public CGLContextObj(long address) {
            this.address = address;
        }

        public String toString() {
            return "CGLContextObj[" + this.address + "]";
        }
    }

    public static enum CGLError {
        kCGLNoError(0),
        kCGLBadAttribute(10000),
        kCGLBadProperty(10001),
        kCGLBadPixelFormat(10002),
        kCGLBadRendererInfo(10003),
        kCGLBadContext(10004),
        kCGLBadDrawable(10005),
        kCGLBadDisplay(10006),
        kCGLBadState(10007),
        kCGLBadValue(10008),
        kCGLBadMatch(10009),
        kCGLBadEnumeration(10010),
        kCGLBadOffScreen(10011),
        kCGLBadFullScreen(10012),
        kCGLBadWindow(10013),
        kCGLBadAddress(10014),
        kCGLBadCodeModule(10015),
        kCGLBadAlloc(10016),
        kCGLBadConnection(10017);

        public final int code;

        private CGLError(int code) {
            this.code = code;
        }

        public static CGLError fromCode(int code) {
            return Arrays.stream(CGLError.values()).filter(v -> v.code == code).findFirst().orElseThrow(() -> new RuntimeException("Unknown CGLError code: " + code));
        }
    }

    public static class IOSurfaceRef
    extends CFTypeRef {
        public IOSurfaceRef(long address) {
            super(address);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.address + "]";
        }
    }

    public static class CFTypeRef {
        public final long address;

        public CFTypeRef(long address) {
            this.address = address;
        }
    }
}

