/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: WSTestServerByte.java 72192 2013-06-21 19:52:38Z djiao $
 */
package com.sun.ts.tests.websocket.spec.servercontainer.addendpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

@ServerEndpoint(value = "/TCKTestServerByte")
public class WSTestServerByte {

	@OnOpen
	public void init(Session session) throws IOException {
		String message = "========TCKTestServerByte opened";
		ByteBuffer data = ByteBuffer.allocate(message.getBytes().length);
		data.put(message.getBytes());
        data.flip();
		session.getBasicRemote().sendBinary(data);
	}

	@OnMessage
	public void respond(ByteBuffer message, Session session) {
		    String message_string = IOUtil.byteBufferToString(message);
			System.out.println("TCKTestServerByte got Direct ByteBuffer message: "
					+ message_string + " from session " + session);
			try {
				ByteBuffer data = ByteBuffer.allocate(("========TCKTestServerByte received ByteBuffer: " + "========TCKTestServerByte responds: Message in bytes").getBytes().length + message.capacity());
				data.put(("========TCKTestServerByte received ByteBuffer: ").getBytes());
				data.put(message_string.getBytes());
				data.put(("========TCKTestServerByte responds: Message in bytes").getBytes());
				data.flip();
				session.getBasicRemote().sendBinary(data);
			} catch (Exception e) {
				e.printStackTrace();
			}
	}

	@OnError
	public void onError(Session session, Throwable t) {
      		System.out.println("TCKTestServerByte onError");
		try {
			session.getBasicRemote().sendText(
					"========TCKTestServerByte onError");
		} catch (Exception e) {
			e.printStackTrace();
		}
		t.printStackTrace();
	}
}