/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: PongMessageHandler.java 73930 2014-08-01 17:07:43Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.client;

import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;

import com.sun.ts.tests.websocket.common.client.ClientEndpoint;
import com.sun.ts.tests.websocket.common.util.IOUtil;

public class PongMessageHandler implements MessageHandler.Whole<PongMessage> {

	ClientEndpoint<String> endpoint;

	public static final String HANDLER_SAYS = "PongMessageHandler says: ";

	public PongMessageHandler(ClientEndpoint<String> endpoint) {
		this.endpoint = endpoint;
	}

	@Override
	public void onMessage(PongMessage msg) {
		endpoint.onMessage(HANDLER_SAYS
				+ IOUtil.byteBufferToString(msg.getApplicationData()));
	}

}
