/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCCloseServerEndpoint.java 72835 2013-09-09 16:00:58Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.endpoint.server;

import java.io.IOException;

import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.util.IOUtil;

public class WSCCloseServerEndpoint extends Endpoint implements
		javax.websocket.MessageHandler.Whole<String> {
	private Session session;
	static final String CLOSE = "@OnClose"; 

	@Override
	public void onMessage(String msg) {
		try {
			session.getBasicRemote().sendText(msg);
		} catch (IOException e) {
			onError(session, e);
		}
	}

	@Override
	public void onOpen(Session session, EndpointConfig config) {
		session.addMessageHandler(this);
		this.session = session;
	}

	@Override
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
		WSCMsgServer.setLastMessage(CLOSE);
	}

	@Override
	public void onError(Session session, Throwable t) {
		super.onError(session, t);
		t.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(t);
		try {
			session.getBasicRemote().sendText(message);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
