/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: InitDestroyBinaryStreamDecoder.java 71440 2013-04-05 15:03:30Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.coder;

import java.io.IOException;
import java.io.InputStream;

import javax.websocket.DecodeException;
import javax.websocket.EndpointConfig;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryStreamDecoder;

public class InitDestroyBinaryStreamDecoder extends
		StringBeanBinaryStreamDecoder {
	@Override
	public void init(EndpointConfig config) {
		Logger.onInit(getClass());
	}

	@Override
	public void destroy() {
		Logger.onDestroy(getClass());
	}
	
	@Override
	public StringBean decode(InputStream arg0) throws DecodeException,
			IOException {
		Logger.onCode(getClass());
		return super.decode(arg0);
	};	
}
