/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.servlet.spec.serverpush;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.PushBuilder;
import java.io.IOException;
import java.io.PrintWriter;

public class TestServlet3 extends HttpServlet {
  @Override
  protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    PrintWriter pw = resp.getWriter();

    if ("true".equals(req.getParameter("generateSession"))) {
      HttpSession session = req.getSession(true);
      pw.print(session.getId());
    } else {
      PushBuilder pb = req.newPushBuilder();
      if (req.getSession(false).getId().equals(pb.getSessionId())) {
        pw.print("Test success");
      } else {
        pw.println("The session ID for the PushBuilder should also come from the same source as the request");
      }
    }
  }
}
