/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $URL: https://adc4110351.us.oracle.com/svn/spider/branches/cts/8.0/src/com/sun/ts/tests/servlet/spec/errorpage/TestServlet.java $ $LastChangedDate: 2011-04-18 13:58:13 -0700 (Mon, 18 Apr 2011) $
 */

package com.sun.ts.tests.servlet.spec.errorpage;

import com.sun.ts.tests.servlet.common.servlets.HttpTCKServlet;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class TestServlet extends HttpTCKServlet {

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
        super.destroy();
    }

//------------------------------------------------- Test Methods

    public void htmlErrorPageTest(HttpServletRequest req, HttpServletResponse res)
        throws ServletException, IllegalAccessException {
        throw new IllegalAccessException("error page invoked");
    }

    public void servletErrorPageTest(HttpServletRequest req, HttpServletResponse res)
        throws ServletException, InstantiationException {
        throw new IllegalStateException("error page invoked");
    }

    public void statusCodeErrorPageTest(HttpServletRequest req, HttpServletResponse res)
        throws ServletException, IOException {
        res.sendError(HttpServletResponse.SC_NOT_IMPLEMENTED, "error page invoked");
    }

    public void heirarchyErrorMatchTest(HttpServletRequest req, HttpServletResponse res)
        throws ServletException, IllegalThreadStateException {
        throw new IllegalThreadStateException("error page invoked");
    }

}// ErrorPageTestServlet
