/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.pluggability.fragment;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public final class TestFilter2 implements Filter {

    private FilterConfig filterConfig = null;

    public void doFilter(ServletRequest request, ServletResponse response,
            FilterChain chain) throws IOException, ServletException {

        PrintWriter pw = response.getWriter();

        pw.println("doFilter in TestFilter2 invoked");

        if (filterConfig == null) {
            pw.println("instance is null");
        } else {
            Enumeration initP = filterConfig.getInitParameterNames();
            int expectedCount = 2;
            int count = 0;

            if (initP.hasMoreElements()) {
                while (initP.hasMoreElements()) {
                    String result = (String) initP.nextElement();
                    pw.println("parameter name= " + result);
                    pw.println("parameter value= " +
                            filterConfig.getInitParameter(result));
                }
            }
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }
}
