/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:i$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.servletcontext30;

import com.sun.ts.tests.servlet.common.util.ServletTestUtil;

import com.sun.ts.tests.servlet.common.util.StaticLog;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class CreateServlet extends GenericServlet {

    public void service(ServletRequest request, ServletResponse response)
            throws ServletException, IOException {

        PrintWriter pw = response.getWriter();

        pw.println("CreateServlet is invoked correctly");

        ArrayList result =
                (ArrayList) getServletContext().getAttribute("arraylist");

        for (Object tmp : result) {
            pw.println(tmp.toString());

        }
        getServletContext().removeAttribute("arraylist");

        result = StaticLog.getClear();
        if (result != null) {
            for (Object tmp : result) {
                if (tmp != null) {
                    pw.println(tmp.toString());
                }
            }
        }
        StaticLog.clear();
        ServletTestUtil.printResult(pw, true);
    }
}
