package com.sun.ts.tests.securityapi.idstore.common;

import javax.security.enterprise.identitystore.IdentityStore.ValidationType;
import static javax.security.enterprise.identitystore.IdentityStore.ValidationType.PROVIDE_GROUPS;
import static javax.security.enterprise.identitystore.IdentityStore.ValidationType.VALIDATE;

import javax.security.enterprise.identitystore.LdapIdentityStoreDefinition.LdapSearchScope; 
import static javax.security.enterprise.identitystore.LdapIdentityStoreDefinition.LdapSearchScope.ONE_LEVEL;
import static javax.security.enterprise.identitystore.LdapIdentityStoreDefinition.LdapSearchScope.SUBTREE;

import javax.enterprise.context.RequestScoped;
import javax.inject.Named;

@RequestScoped
@Named
public class ConfigBean {
 	
	private int priority300=300;
	private int priority100=100;
	private ValidationType[] useforBoth = {ValidationType.VALIDATE, ValidationType.PROVIDE_GROUPS};
	private ValidationType[] useforValidate = {ValidationType.VALIDATE};
	private ValidationType[] useforProvideGroup = {ValidationType.PROVIDE_GROUPS};
	private LdapSearchScope searchScopeOneLevel = ONE_LEVEL;
	private LdapSearchScope searchScopeSubTree = SUBTREE;
	
	public int getPriority300(){
		return priority300;
	}
	
	public int getPriority100(){
		return priority100;
	}	
	
	public ValidationType[] getUseforBoth(){
		return useforBoth;		
	}
	
	public ValidationType[] getUseforValidate(){
		return useforValidate;		
	}
	
	public ValidationType[] getUseforProvideGroup(){
		return useforProvideGroup;		
	}
	
	public LdapSearchScope getSearchScopeOneLevel(){
		return ONE_LEVEL;
	}
	
	public LdapSearchScope getSearchScopeSubTree(){
		return SUBTREE;
	}
}
