/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.PropertiesQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.RenderingUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class PropertiesQuestionRenderer
implements QuestionRenderer {
    protected Runnable valueSaver;
    protected HashMap tables;
    protected TableCellRenderer renderer;
    protected PropertiesQuestion question;
    protected JPanel panel;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    @Override
    public JComponent getQuestionRendererComponent(Question qq, ActionListener listener) {
        this.question = (PropertiesQuestion)qq;
        this.tables = new HashMap();
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setName("properties");
        this.panel.setFocusable(false);
        if (this.question.getValue() == null) {
            this.showEmptyQuestion(this.panel);
            return this.panel;
        }
        this.addGroup(null, this.panel, listener);
        String[] groups = this.question.getGroups();
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                this.addGroup(groups[i], this.panel, listener);
            }
        }
        if (this.panel.getComponentCount() == 0) {
            this.showEmptyQuestion(this.panel);
        }
        this.valueSaver = new Runnable(){

            @Override
            public void run() {
                Set keys = PropertiesQuestionRenderer.this.tables.keySet();
                Iterator iter = keys.iterator();
                while (iter.hasNext()) {
                    JTable table = (JTable)PropertiesQuestionRenderer.this.tables.get((String)iter.next());
                    TableCellEditor editor = table.getCellEditor();
                    if (editor == null) continue;
                    editor.stopCellEditing();
                }
            }
        };
        this.panel.putClientProperty("valueSaver", this.valueSaver);
        this.panel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent e) {
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent e) {
                if (PropertiesQuestionRenderer.this.valueSaver != null) {
                    PropertiesQuestionRenderer.this.valueSaver.run();
                }
            }
        });
        return this.panel;
    }

    @Override
    public String getInvalidValueMessage(Question q) {
        return null;
    }

    protected void showEmptyQuestion(JPanel panel) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 19;
        gbc.fill = 1;
        gbc.weightx = 2.0;
        JTextArea txt = new JTextArea(i18n.getString("props.empty.txt"));
        txt.setOpaque(false);
        txt.setEditable(false);
        txt.setLineWrap(true);
        txt.setWrapStyleWord(true);
        txt.setFocusTraversalKeys(0, null);
        txt.setFocusTraversalKeys(1, null);
        AccessibleContext ac = txt.getAccessibleContext();
        ac.setAccessibleName(i18n.getString("props.message.name"));
        ac.setAccessibleDescription(i18n.getString("props.message.desc"));
        panel.add((Component)txt, gbc);
    }

    private void addGroup(String group, JPanel panel, ActionListener listener) {
        TableModel model = this.createTableModel(group, listener);
        if (model.getRowCount() == 0) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = this.tables.size() * 4;
        c.anchor = 19;
        c.weightx = 1.0;
        c.fill = 1;
        if (c.gridy > 0) {
            Component box = Box.createVerticalStrut(40);
            box.setFocusable(false);
            c.weighty = 1.0;
            panel.add(box, c);
            c.weighty = 0.0;
        }
        if (group != null) {
            JLabel label = new JLabel(this.question.getGroupDisplayName(group));
            label.setName(this.question.getGroupDisplayName(group));
            panel.add((Component)label, c);
        }
        if (this.renderer == null) {
            this.renderer = new RenderingUtilities.PropCellRenderer(this.question);
        }
        JTable table = this.createTable(model);
        table.setBorder(BorderFactory.createEtchedBorder());
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.getTableHeader().setReorderingAllowed(false);
        for (int i = 0; i < table.getColumnCount(); ++i) {
            TableColumn tc = table.getColumnModel().getColumn(i);
            tc.setCellRenderer(this.getCellRenderer(i));
            TableCellEditor editor = this.getCellEditor(i);
            if (editor != null) {
                tc.setCellEditor(editor);
            }
            tc.setResizable(true);
        }
        ++c.gridy;
        panel.add((Component)table.getTableHeader(), c);
        ++c.gridy;
        panel.add((Component)table, c);
        this.tables.put(group, table);
    }

    protected TableCellEditor getCellEditor(int column) {
        if (column == 1) {
            return new RenderingUtilities.PCE(this.question);
        }
        return null;
    }

    protected TableCellRenderer getCellRenderer(int column) {
        return this.renderer;
    }

    protected String[] getTableHeaders() {
        return new String[]{this.question.getKeyHeaderName(), this.question.getValueHeaderName()};
    }

    protected TableModel createTableModel(String group, ActionListener l) {
        return new PropTableModel(this.getTableHeaders(), group, this.question, l);
    }

    protected JTable createTable(TableModel model) {
        return new PropJTable(model);
    }

    private void fireEditedEvent(Object src, ActionListener l) {
        ActionEvent e = new ActionEvent(src, 1001, "edited");
        l.actionPerformed(e);
    }

    protected class PropTableModel
    extends DefaultTableModel {
        protected PropertiesQuestion q;
        protected ActionListener editedListener;

        protected PropTableModel(String[] headers, String group, PropertiesQuestion q, ActionListener listener) {
            this.q = q;
            this.editedListener = listener;
            this.setColumnCount(headers.length);
            Object[][] d = q.getGroup(group);
            if (d != null) {
                ArrayList<Object> rm = null;
                for (int i = 0; i < d.length; ++i) {
                    if (q.isEntryVisible(d[i][0])) continue;
                    if (rm == null) {
                        rm = new ArrayList<Object>();
                    }
                    rm.add(d[i][0]);
                }
                if (rm != null) {
                    String[][] d2 = new String[d.length - rm.size()][2];
                    int pos = 0;
                    for (int i = 0; i < d.length; ++i) {
                        if (rm.contains(d[i][0])) continue;
                        d2[pos][0] = d[i][0];
                        d2[pos][1] = d[i][1];
                        ++pos;
                    }
                    d = d2;
                }
                this.setDataVector(d, headers);
            }
        }

        @Override
        public void setValueAt(Object o, int row, int col) {
            if (col == 1) {
                String key = (String)this.getValueAt(row, 0);
                this.q.updateProperty(key, (String)o);
                PropertiesQuestionRenderer.this.fireEditedEvent(this, this.editedListener);
                this.fireTableCellUpdated(row, 0);
                this.fireTableCellUpdated(row, 1);
                o = this.q.getValue().get(key);
            }
            super.setValueAt(o, row, col);
        }
    }

    protected class PropJTable
    extends JTable {
        protected PropJTable(TableModel model) {
            super(model);
            this.setIntercellSpacing(new Dimension(4, 4));
            this.setRowHeight((int)((double)this.getRowHeight() * 1.5));
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 0) {
                return false;
            }
            return column != 1 || !PropertiesQuestionRenderer.this.question.isReadOnlyValue((String)this.getValueAt(row, 0));
        }
    }
}

