/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: StringUTFConverter.java 69653 2013-01-25 16:50:07Z adf $
 */

/*
 * Usage: java StringUTFConverter inputstring encoding outputfile
 *
 * Utility program to convert an input string to a UTF encoded output file.
 *
 * Example(s):
 *
 * java StringUTFConverter "foo" UTF-16LE fooUTF16LE
 *
 * The above converts an input string "foo" and outputs to UTF-16LE encoded
 * output file (fooUTF16LE).
 */

package com.sun.ts.tests.jsonp.util;

import java.io.*;

public class StringUTFConverter {

    private static final String USAGE="Usage : java StringUTFConverter inputstring encoding outputfile";

    public static void main(String args[]) {
        try {
            if (args.length != 3) {
		System.err.println(USAGE);
                System.exit(1);
            }

	    // Convert string to specified UTF encoded output file
	    System.out.println("StringtoUTF-> convert string (" +
				args[0] + "), to encoding (" + args[1] +
				") and write to output file (" + args[2] +")");
            FileOutputStream fos = new FileOutputStream(args[2]);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos, args[1]));
            bw.write(args[0]);
            bw.flush();
            bw.close();

            System.exit(0);

        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

