/*
 * Copyright (c) 2007, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 
package com.sun.ts.tests.jpa.se.schemaGeneration.annotations.orderColumn;

import javax.persistence.*;
import java.util.List;

@Entity
@Table(name="SCHEMAGENDEPT")
public class Department implements java.io.Serializable {

    // Instance variables
    private int  deptId;
    private List<Employee> employees;

    public Department() {
    }

    public Department(int id) {
        this.deptId = id;
    }

    @Id
    public int getDeptId() {
        return deptId;
    }
    public void setDeptId(int id) {
        this.deptId = id;
    }

    @OneToMany(mappedBy="department")
    @OrderColumn(name = "THEORDERCOLUMN")
    public List <Employee> getEmployees() {
        return employees;
    }
    public void setEmployees(List<Employee> employees) {
        this.employees = employees;
    }
    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName()+"[");
        result.append("id: " + getDeptId());
        result.append("]");
        return result.toString();
    }
    public boolean equals(Object o) {
        Department other;
        boolean result = false;

        if (!(o instanceof Department)) {
            return result;
        }
        other = (Department) o;

        if (this.getDeptId() == other.getDeptId()
                ) {
            result = true;
        }

        return result;
    }


    public int hashCode() {
        int myHash;

        myHash = this.getDeptId();

        return myHash;
    }
}
