/*
 * Copyright (c) 2013, 2018, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.se.schemaGeneration.annotations.joinTable;

import javax.persistence.*;
import java.util.List;


@Entity
@Table(name = "SCHEMAGENCOURSE")
public class Course implements java.io.Serializable {
	private static final long serialVersionUID = 22L;
	int courseId;
    String courseName;
    List<Student> students;

    public Course() {
    }

    public Course(int id, String name) {
        this.courseId = id;
        this.courseName = name;
    }

    @Id
    public int getCourseId() {
        return courseId;
    }

    public void setCourseId(int id) {
        this.courseId = id;
    }

    public String getCourseName() {
        return courseName;
    }

    public void setCourseName(String courseName) {
        this.courseName = courseName;
    }

    @JoinTable(name = "SCHEMAGEN_COURSE_STUDENT",
                joinColumns = @JoinColumn(name = "COURSE_ID"),
                inverseJoinColumns = @JoinColumn(name = "STUDENT_ID"),
                foreignKey = @ForeignKey(name = "COURSEIDCONSTRAINT", value = ConstraintMode.CONSTRAINT, foreignKeyDefinition = "FOREIGN KEY (COURSE_ID) REFERENCES SCHEMAGENCOURSE (COURSEID)"),
                inverseForeignKey = @ForeignKey(name = "STUDENTIDCONSTRAINT", value = ConstraintMode.CONSTRAINT, foreignKeyDefinition = "FOREIGN KEY (STUDENT_ID) REFERENCES SCHEMAGENSTUDENT (STUDENTID)")
        )
    @ManyToMany(cascade = CascadeType.ALL)
    public List<Student> getStudents() {
        return students;
    }

    public void setStudents(List<Student> students) {
        this.students = students;
    }

    public int hashCode() {

        return this.courseId;
    }

    public boolean equals(Object obj) {
        boolean result = false;

        if ((obj != null) && (obj instanceof Course)) {
            Course course = (Course) obj;
            result = (course.getCourseId() == this.getCourseId());
        }
        return result;
    }


}
