/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */


package com.sun.ts.tests.jpa.jpa22.repeatable.attroverride;

import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Entity;
import javax.persistence.Id;
import java.math.BigDecimal;

/*
 * Project
 */

@Entity
@Access(AccessType.PROPERTY)
public class Project implements java.io.Serializable  {

	private static final long serialVersionUID = 22L;
    private long       		projId;
    private String     		name;
    private BigDecimal 		budget;
    
    public Project() {
    }

    public Project(long projId, String name, BigDecimal budget) {
        this.projId = projId;
        this.name = name;
        this.budget = budget;
    }

   // ===========================================================
   // getters and setters for the state fields

    @Id
    public long getProjId() {
        return projId;
    }
    public void setProjId(long projId) {
        this.projId = projId;
    }

    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getBudget() {
        return budget;
    }
    public void setBudget(BigDecimal budget) {
        this.budget = budget;
    }

}

