/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
  * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
  */

package com.sun.ts.tests.jpa.core.types.generator;

import javax.persistence.*;

@Entity
@Access(AccessType.PROPERTY)
@Table(name = "DATATYPES")
public class DataTypes4 implements java.io.Serializable {

    private int id;
    private Integer integerData;


    public DataTypes4()
    {
    }

    public DataTypes4(Integer integerData)
    {
        this.integerData = integerData;

    }

   @Id
   @SequenceGenerator(name = "SEQGENERATOR",  allocationSize = 1, initialValue = 10)
   @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "SEQGENERATOR")
   @Column(name="ID")
   public int getId()
   {
      return id;
   }
   public void setId(int id)
   {
      this.id= id;
   }

   @Column(name = "INTDATA")
   public Integer getIntegerData() {
       return integerData;
   }
   public void setIntegerData(Integer integerData)
   {
      this.integerData = integerData;
   }

}
