/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: XProject.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.relationship.descriptors;

import com.sun.ts.lib.util.TestUtil;

import java.math.BigDecimal;
import java.util.Collection;

/*
 * XProject
 */

public class XProject implements java.io.Serializable  {

    // Instance Variables
    private long       		xProjId;
    private String     		xName;
    private BigDecimal 		xBudget;
    private XPerson 		xProjectLead;
    private Collection<XPerson>	xPersons = new java.util.ArrayList<XPerson>();

    public XProject() {
	TestUtil.logTrace("XProject no-arg constructor");
    }

    public XProject(long xProjId, String xName, BigDecimal xBudget) {
        this.xProjId = xProjId;
        this.xName = xName;
        this.xBudget = xBudget;
    }

   // ===========================================================
   // getters and setters for the state fields

    public long getXProjId() {
        return xProjId;
    }
    public void setXProjId(long xProjId) {
        this.xProjId = xProjId;
    }

    public String getXName() {
        return xName;
    }
    public void setXName(String xName) {
        this.xName = xName;
    }

    public BigDecimal getXBudget() {
        return xBudget;
    }
    public void setXBudget(BigDecimal xBudget) {
        this.xBudget = xBudget;
    }

   // ===========================================================
   // getters and setters for the association fields

    /* Bi-Directional OneProjectLeadToOnePerson */
    public XPerson getXProjectLead() {
        return xProjectLead;
    }
    public void setXProjectLead(XPerson xProjectLead) {
        this.xProjectLead = xProjectLead;
    }

    /* Bi-Directional ManyPersonsToManyProjects */
    public Collection<XPerson> getXPersons() {
        return xPersons;
    }
    public void setXPersons(Collection<XPerson> xPersons) {
        this.xPersons = xPersons;
    }

}

