/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 

/*
 * $Id: PartTimeEmployee.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.inheritance.abstractentity;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import java.sql.Date;

/*
 * PartTimeEmployee
 */

@Entity
@DiscriminatorValue("NONEXEMPT")
public class PartTimeEmployee extends Employee {

    private float wage;

    public PartTimeEmployee() {
    }

    public PartTimeEmployee(int id, String firstName, String lastName, Date hireDate,
                        float salary)
    {
                this.id = id;
                this.firstName = firstName;
                this.lastName = lastName;
                this.hireDate = hireDate;
                this.wage = wage;
    }


   // ===========================================================
   // getters and setters for the state fields

    @Column(name="SALARY")
    public float getWage() {
        return wage;
    }
    public void setWage(float wage) {
        this.wage = wage;
    }
    
}
