/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: A.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.entitytest.persist.oneXone;

import com.sun.ts.lib.util.TestUtil;

import javax.persistence.*;

@Entity
@Table(name="AEJB_1X1_BI_BTOB")
public class A implements java.io.Serializable {


    // ===========================================================
    // instance variables 

    @Id
    protected String id;

    @Basic
    protected String name;

    @Basic
    protected int value;


    // ===========================================================
    // constructors

    public A() {
        TestUtil.logTrace("Entity A no arg constructor");
    }

    public A(String id, String name, int value)
    {
      this.id = id;
      this.name = name;
      this.value = value;
    }

    public A(String id, String name, int value, B b1)
    {
      this.id = id;
      this.name = name;
      this.value = value;
      this.b1 = b1;
    }


    // ===========================================================
    // relationship fields

    @OneToOne(targetEntity=com.sun.ts.tests.jpa.core.entitytest.persist.oneXone.B.class, mappedBy="a1")
    protected B b1;

    // =======================================================================
    // Business methods for test cases

    public B getB1() {
        return b1;
    }

    public boolean isB1()
    {
        TestUtil.logTrace("isB1");
        if (getB1() != null)
            TestUtil.logTrace("Relationship to B is not null...");
        else
            TestUtil.logTrace("Relationship for B is null ...");
        return getB1() != null;
    }

    public B getB1Info()
    {
        TestUtil.logTrace("getBInfo");
          if (isB1()) {
            B b1 = getB1();
            return b1;
          } else 
            return null;
    }

    public String getAId()
    {   
        return id;
    }

    public String getAName()
    {
        return name;
    }

    public int getAValue()
    {
        return value;
    }

}
