/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.derivedid.ex4b;

import javax.persistence.*;
import java.io.Serializable;

/**
 *
 * @author Raja Perumal
 */
@Entity
public class DID4bMedicalHistory implements Serializable {

    private static final long serialVersionUID = 1L;
    @Id String id;
    @MapsId
    @JoinColumn(name="ID")
    @OneToOne
    private  DID4bPerson patient;
    private String doctorName;

    public DID4bMedicalHistory() {
    }

    public DID4bMedicalHistory(DID4bPerson patient, String doctorName) {
        this.patient = patient;
        this.doctorName = doctorName;
    }

    public DID4bMedicalHistory(String id, DID4bPerson patient, String doctorName) {
        this.id = id;
        this.patient = patient;
        this.doctorName = doctorName;
    }

    public DID4bPerson getPatient() {
        return patient;
    }

    public void setPatient(DID4bPerson patient) {
        this.patient = patient;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (patient != null ? patient.hashCode() : 0);
        return hash;
    }

    public String getDoctorName() {
        return doctorName;
    }

    public void setDoctorName(String doctorName) {
        this.doctorName = doctorName;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DID4bMedicalHistory)) {
            return false;
        }
        DID4bMedicalHistory other = (DID4bMedicalHistory) object;
        if ((this.patient == null && other.patient != null) || (this.patient != null && !this.patient.equals(other.patient))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "derivedpatient4.DID4MedicalHistory[patient=" + patient + "]";
    }
}
