/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.derivedid.ex2b;

import javax.persistence.Embeddable;

/**
 *
 * @author Raja Perumal
 */
@Embeddable
public class DID2bDependentId implements java.io.Serializable {

    String name;
    DID2bEmployeeId empPK;

    public DID2bDependentId() {
    }

    public DID2bDependentId(String name, DID2bEmployeeId emp) {
        this.name = name;
        this.empPK = emp;
    }

    public DID2bEmployeeId getEmpPK() {
        return empPK;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final DID2bDependentId other = (DID2bDependentId) obj;
        if ((this.name == null) ? (other.name != null) : !this.name.equals(other.name)) {
            return false;
        }
        if (this.empPK != other.empPK && (this.empPK == null || !this.empPK.equals(other.empPK))) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public void setEmpPK(DID2bEmployeeId emp) {
        this.empPK = emp;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

 
}
