/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */


package com.sun.ts.tests.jpa.core.annotations.nativequery;

import javax.persistence.*;


/*
 * Item
 */

@Entity
@Table(name="ITEM")
public class Item implements java.io.Serializable
{


    // Instance variables
    private int id;
    private String itemName;
    private Order1 order1;

    public Item()
    {
    }

    public Item (int id, String itemName)
    {
        this.id = id;
        this.itemName = itemName;
    }


    //====================================================================
    // getters and setters for State fields

    @Id
    @Column(name="ID")
    public int getId() {
	return id;
    }
    public void setId(int id) {
	this.id = id;
    }

    @Column(name="ITEMNAME")
    public String getItemName() {
	return itemName;
    }
    public void setItemName(String itemName) {
	this.itemName = itemName;
    }

    @OneToOne(mappedBy="item")
    public Order1 getOrder1()
    {
        return order1;
    }
    public void setOrder1(Order1 v)
    {
        order1 = v;
    }

    @Override
    public int hashCode() {
        return this.getId() +
                this.getItemName().hashCode();
    }

   public boolean equals(Object obj) {
        boolean result = false;

        if ((obj != null) && (obj instanceof Item)) {
            Item i = (Item) obj;
            result = (i.id==getId()
                    && i.itemName.equals(getItemName()));
        }
        return result;
    }
    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName()+"[");
        result.append("id: " + getId());
        result.append(", name: " + getItemName());
        result.append("]");
        return result.toString();
    }
}
