/*
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.core.annotations.convert;

import javax.persistence.*;

/*
 * Employee as mapped superclass, which can be concrete or abstract.
 * Mapping may be overriden by subclass entities with annotation or descriptor.
 */

@MappedSuperclass()
public abstract class Employee2 {

    private  int	     id;
    private  String	     firstName;
    private  char[] lastName;

    protected Employee2() {}

    protected Employee2(int id, String firstName, char[] lastName) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
    }
    
   // ===========================================================
   // getters and setters for the state fields

    @Id
    @Column(name="IDxx")
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }

    @Column(name="FIRSTNAMExx")
    public String getFirstName() {
        return firstName;
    }
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="LASTNAMExx")
    public char[] getLastName() {
        return lastName;
    }
    public void setLastName(char[] lastName) {
        this.lastName = lastName;
    }


}

