/*
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 

package com.sun.ts.tests.jpa.core.annotations.access.mappedsc;

import javax.persistence.*;
import java.sql.Date;

/*
 * PartTimeEmployee entity extends an MappedSuperClass while overriding
 * mapping information.
 */

@Entity
@AttributeOverrides({
        @AttributeOverride(name="id",column=@Column(name="ID")),
        @AttributeOverride(name="firstName",column=@Column(name="FIRSTNAME")),
        @AttributeOverride(name="lastName",column=@Column(name="LASTNAME")),
        @AttributeOverride(name="hireDate",column=@Column(name="HIREDATE"))
})
@Access(AccessType.PROPERTY)
public class PartTimeEmployee extends Employee {

    private float wage;

    public PartTimeEmployee() {
    }

    public PartTimeEmployee(int id, String firstName, String lastName, Date hireDate,
                        float salary)
    {
                super(id, firstName, lastName, hireDate);
                this.wage = wage;
    }


   // ===========================================================
   // getters and setters for the state fields

    @ManyToOne
    @JoinColumn(name="FK_DEPT2")
    public Department getDepartment() {
        return department;
    }

    @Column(name="SALARY")
    public float getWage() {
        return wage;
    }
    public void setWage(float wage) {
        this.wage = wage;
    }
    
}
