/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R4003;

import java.util.Properties;

import com.sun.javatest.Status;
import com.sun.ts.tests.jaxws.sharedclients.ClientFactory;

import com.sun.ts.lib.harness.*;

public class Client extends ServiceEETest {
    /**
     * The string to be echoed. 
     */
    private static final String STRING = "R4003";
    
    /**
     * The client.
     */
    private W2JRLR4003Client client;

    
    static W2JRLR4003TestService service = null;
    
    /**
     * Test entry point.
     * 
     * @param args the command-line arguments.
     */
    public static void main(String[] args) {
        Client client = new Client();
        Status status = client.run(args, System.out, System.err);
        status.exit();
    }

    
    /**
     * @class.testArgs:     -ap jaxws-url-props.dat
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     platform.mode;
     *
     * @param args
     * @param properties
     *
     * @throws Fault
     */
    public void setup(String[] args, Properties properties) throws Fault {
        client = (W2JRLR4003Client)ClientFactory.getClient(W2JRLR4003Client.class, properties, this, service);
        logMsg("setup ok");
    }

    public void cleanup() {
        logMsg("cleanup");
    }

    /**
     * @testName: testWSDLImportUTF8UTF16
     *
     * @assertion_ids: WSI:SPEC:R4003
     *
     * @test_Strategy: The supplied WSDL imports both a UTF8 and UTF16 wsdl.
     *
     * @throws Fault
     */
    public void testWSDLImportUTF8UTF16() throws Fault {
        testImportUTF8WSDL();
        testImportUTF16WSDL();
    }

    private void testImportUTF8WSDL() throws Fault {
        String result;
        try {
            result = client.echoStringUTF8(STRING);
        } catch (Exception e) {
            throw new Fault("Unable to invoke echoStringUTF8 operation (BP-R4003)", e);
        }
        if (!STRING.equals(result)) {
            throw new Fault("echoStringUTF8 operation returns '" + result + "' in stead of '" + STRING + "' (BP-R4003)");
        }
    }

    private void testImportUTF16WSDL() throws Fault {
        String result;
        try {
            result = client.echoStringUTF16(STRING);
        } catch (Exception e) {
            throw new Fault("Unable to invoke echoStringUTF16 operation (BP-R4003)", e);
        }
        if (!STRING.equals(result)) {
            throw new Fault("echoStringUTF16 operation returns '" + result + "' in stead of '" + STRING + "' (BP-R4003)");
        }
    }

}
