/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SwaTestClient2.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.wsi.w2j.document.literal.swatest;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;

import com.sun.ts.tests.jaxws.common.*;

public class SwaTestClient2 extends SOAPClient {

    public SwaTestClient2(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
	this(webServerHost, webServerPort, mode, null);
    }

    public SwaTestClient2(String webServerHost, int webServerPort, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault{

        super(webServerHost, webServerPort, mode);
        stubContext.setNamespace("http://SwaTestService.org/wsdl");
        stubContext.setService("WSIDLSwaTestService");
        stubContext.setPort("SwaTestTwoPort");
        stubContext.setEndpointInterface(SwaTest2.class);
	stubContext.setWebServiceRef(webServiceRef);
    }

    protected String getEndpointURLProperty() {
        return "wsidlswatest.endpoint.2";
    }

    protected String getWSDLURLProperty() {
        return "wsidlswatest.wsdlloc.1";
    }

    public com.sun.ts.tests.jaxws.wsi.w2j.document.literal.swatest.OutputResponseString putMultipleAttachments(com.sun.ts.tests.jaxws.wsi.w2j.document.literal.swatest.InputRequestPut request, javax.activation.DataHandler attach1, javax.activation.DataHandler attach2) throws Exception {
        return ((SwaTest2)stubContext.getStub()).putMultipleAttachments(request, attach1, attach2);
    }

    public com.sun.ts.tests.jaxws.wsi.w2j.document.literal.swatest.OutputResponseString echoNoAttachments(com.sun.ts.tests.jaxws.wsi.w2j.document.literal.swatest.InputRequestString request) throws Exception {
        return ((SwaTest2)stubContext.getStub()).echoNoAttachments(request);
    }
}
