/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SwaTestClient1.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.wsi.w2j.document.literal.swatest;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;

import com.sun.ts.tests.jaxws.common.*;

public class SwaTestClient1 extends SOAPClient {

    public SwaTestClient1(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
	this(webServerHost, webServerPort, mode, null);
    }

    public SwaTestClient1(String webServerHost, int webServerPort, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault{

        super(webServerHost, webServerPort, mode);
        stubContext.setNamespace("http://SwaTestService.org/wsdl");
        stubContext.setService("WSIDLSwaTestService");
        stubContext.setPort("SwaTestOnePort");
        stubContext.setEndpointInterface(SwaTest1.class);
	stubContext.setWebServiceRef(webServiceRef);
    }

    protected String getEndpointURLProperty() {
        return "wsidlswatest.endpoint.1";
    }

    protected String getWSDLURLProperty() {
        return "wsidlswatest.wsdlloc.1";
    }

    public com.sun.ts.tests.jaxws.wsi.w2j.document.literal.swatest.OutputResponse echoMultipleAttachments(com.sun.ts.tests.jaxws.wsi.w2j.document.literal.swatest.InputRequest request, javax.xml.ws.Holder<javax.activation.DataHandler> attach1, javax.xml.ws.Holder<javax.activation.DataHandler> attach2) throws Exception {
        return ((SwaTest1)stubContext.getStub()).echoMultipleAttachments(request, attach1, attach2);
    }
}
