/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MTOMClientTwo.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.ee.w2j.document.literal.mtomtest;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;

import javax.xml.ws.*;
import javax.xml.ws.soap.SOAPBinding;
import java.awt.Image;


public class MTOMClientTwo extends SOAPClient {

    public MTOMClientTwo(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
	this(webServerHost, webServerPort, mode, null);
    }

    public MTOMClientTwo(String webServerHost, int webServerPort, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault{
        super(webServerHost, webServerPort, mode);
        stubContext.setNamespace("http://mtomtestservice.org/wsdl");
        stubContext.setService("MTOMTestService");
        stubContext.setPort("MTOMTestTwoPort");
        stubContext.setEndpointInterface(MTOMTestTwo.class);
	stubContext.setWebServiceRef(webServiceRef);
    }

    protected String getEndpointURLProperty() {
        return "w2jdlmtomtest.endpoint.2";
    }

    protected String getWSDLURLProperty() {
        return "w2jdlmtomtest.wsdlloc.2";
    }

    public void mtomInOut2(Holder<String> s, Holder<Image> h) throws Exception {
        MTOMTestTwo port = (MTOMTestTwo)stubContext.getStub();
        SOAPBinding binding = (SOAPBinding)((BindingProvider)port).getBinding();
        binding.setMTOMEnabled(true);
        port.mtomInOut2(s,h);
    }
}
