/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: LogicalHandler.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.ee.w2j.document.literal.handlerchaintest;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

import javax.xml.soap.*;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.*;
import javax.xml.ws.handler.*;
import javax.xml.namespace.QName;

import com.sun.ts.tests.jaxws.common.Handler_Util;
import com.sun.ts.tests.jaxws.common.JAXWS_Util;
import com.sun.ts.tests.jaxws.common.Constants;
import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.bind.JAXBContext;


public class LogicalHandler implements javax.xml.ws.handler.LogicalHandler<LogicalMessageContext>
{
    private final String HANDLER_NAME="ServerLogicalHandler";
    public boolean handleMessage(LogicalMessageContext context)
    {
        System.out.println("in "+HANDLER_NAME+":handleMessage");

        String direction = Handler_Util.getDirection(context);
        if (Handler_Util.checkForMsg(this, context, "HandlerChainOnProviderTest")) {
            HandlerChainOnProviderTest(context, direction);
        } else {
            System.out.println("didn't find HandlerChainOnProviderTest message, handler will ignore");
        }
        System.out.println("exiting "+HANDLER_NAME+":handleMessage");
        return true;
    }


    public void HandlerChainOnProviderTest(LogicalMessageContext context, String direction){
        System.out.println("in "+HANDLER_NAME+":HandlerChainOnProviderTest");

        Handler_Util.dumpMsg(context);

        String tmp = Handler_Util.getMessageAsString(context);
        String newTmp = tmp.replaceAll("HandlerChainOnProviderTest","HandlerChainOnProviderTest"+direction+HANDLER_NAME);
        context.getMessage().setPayload(new StreamSource(new StringReader(newTmp)));
        Handler_Util.dumpMsg(context);


        System.out.println("exiting "+HANDLER_NAME+":HandlerChainOnProviderTest");
    }

    public void close(MessageContext context)
    {
       System.out.println("in "+HANDLER_NAME+":close");
    }

    public boolean handleFault(LogicalMessageContext context)
    {
        System.out.println("in "+HANDLER_NAME+":handleFault");
        return true;
    }

}





