/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: NoMediaResource.java 75048 2017-06-12 17:36:23Z jsupol $
 */

package com.sun.ts.tests.jaxrs.spec.resource.responsemediatype;

import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path("nomedia")
public class NoMediaResource {

	@GET
	@Path("list")
	public List<String> serializable() {
		return java.util.Collections.singletonList("AA");
	}

	@GET
	@Path("responseoverride")
	public Response overrideNoProduces() {
		return Response.ok("<a>responseoverride</a>")
				.type(MediaType.APPLICATION_XML_TYPE).build();
	}
}
