/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: JAXRSClient.java 69871 2013-02-06 19:05:54Z supol $  
 */

package com.sun.ts.tests.jaxrs.spec.provider.jaxbcontext;

import javax.ws.rs.core.MediaType;

import com.sun.ts.tests.jaxrs.common.JAXRSCommonClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 */

public class JAXRSClient extends JAXRSCommonClient {

	private static final long serialVersionUID = 1L;

	public JAXRSClient() {
		setContextRoot("/jaxrs_spec_provider_jaxbcontext_web/resource");
	}

	private void setPropertyAndInvoke(String resourceMethod) throws Fault {
		setProperty(Property.REQUEST,
				buildRequest(Request.POST, resourceMethod));
		setProperty(Property.REQUEST_HEADERS,
				buildContentType(MediaType.APPLICATION_XML_TYPE));
		setProperty(Property.SEARCH_STRING,
				SomeUnmarshaller.class.getSimpleName());
		setProperty(Property.SEARCH_STRING,
				SomeMarshaller.class.getSimpleName());
		setProperty(Property.CONTENT, "anything");
		invoke();
	}

	/**
	 * Entry point for different-VM execution.  It should delegate to method
	 * run(String[], PrintWriter, PrintWriter), and this method should not
	 * contain any test configuration.
	 */
	public static void main(String[] args) {
		new JAXRSClient().run(args);
	}

	/* Run test */
	/*
	 * @testName: readWriteProviderTest
	 * @assertion_ids: JAXRS:SPEC:34
	 * @test_Strategy: The implementation-supplied entity provider(s) for 
	 * 					javax.xml.bind.JAXBElement and application supplied 
	 * 					JAXB classes MUST use JAXBContext instances provided 
	 * 					by application-supplied context resolvers, see 
	 * 					Section 4.3.
	 */
	public void readWriteProviderTest() throws Fault {
		setPropertyAndInvoke("jaxb");
	}

}
