/*
 * $Id$
 *
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jaxrs.api.rs.ext.runtimedelegate.setinstance;

import javax.ws.rs.ext.RuntimeDelegate;

import com.sun.ts.tests.jaxrs.api.rs.ext.runtimedelegate.JAXRSDelegateClient;
import com.sun.ts.tests.jaxrs.api.rs.ext.runtimedelegate.TckRuntimeDelegate;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 */
public class JAXRSClient extends JAXRSDelegateClient {

	private static final long serialVersionUID = -5586431064207012301L;

	/**
	 * Entry point for different-VM execution. It should delegate to method
	 * run(String[], PrintWriter, PrintWriter), and this method should not
	 * contain any test configuration.
	 */
	public static void main(String[] args) {
		JAXRSClient theTests = new JAXRSClient();
		theTests.run(args);
	}

	/* Run test */
	/*
	 * @testName: askForTckRuntimeDelegateGivenBySetInstanceTest
	 * @assertion_ids: JAXRS:JAVADOC:291;JAXRS:JAVADOC:292;
	 * @test_Strategy: Set new RuntimeDelegate and check it is TckRuntimeDelegate  
	 * 				    
	 */
	public void askForTckRuntimeDelegateGivenBySetInstanceTest() throws Fault {
		RuntimeDelegate original = RuntimeDelegate.getInstance();
		RuntimeDelegate.setInstance(new TckRuntimeDelegate());
		try {
			assertRuntimeDelegate();
		} finally {
			RuntimeDelegate.setInstance(original);
			assertRuntimeDelegate(false);
		}
	}

	/*
	 * @testName: checkTckRuntimeDelegateIsNotDefaultTest
	 * @assertion_ids: JAXRS:JAVADOC:292;
	 * @test_Strategy: Check by default, it is not our RuntimeDelegate 
	 */
	public void checkTckRuntimeDelegateIsNotDefaultTest() throws Fault {
		assertRuntimeDelegate(false);
	}

}
