/*
 * Copyright (c) 2012, 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: HigherPriorityProvider.java 74330 2015-02-09 12:52:10Z jsupol $ 
 */

package com.sun.ts.tests.jaxrs.api.rs.bindingpriority;

import java.util.concurrent.atomic.AtomicInteger;

import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;

import com.sun.ts.lib.harness.EETest.Fault;

@Priority(Integer.MIN_VALUE)
// the lower the number the higher the priority
public class HigherPriorityProvider extends ContextProvider {
	private AtomicInteger counter;

	public HigherPriorityProvider(AtomicInteger counter) {
		super();
		this.counter = counter;
	}

	protected void checkFilterContext(ClientRequestContext context)
			throws Fault {
		assertFault(counter.incrementAndGet() == 1,
				"Lower provider priority has been called as ", counter.get(),
				"nd");
	}
}
