/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.internal.common.Log;
import jdk.incubator.http.internal.common.Utils;
import jdk.incubator.http.internal.common.Utils8;

class SSLDelegate {
    final SSLEngine engine;
    final EngineWrapper wrapper;
    final Lock handshaking = new ReentrantLock();
    final SSLParameters sslParameters;
    final SocketChannel chan;
    final HttpClientImpl client;
    final String serverName;
    int app_buf_size;
    int packet_buf_size;

    SSLDelegate(SSLEngine sSLEngine, SocketChannel socketChannel, HttpClientImpl httpClientImpl, String string) {
        this.engine = sSLEngine;
        this.chan = socketChannel;
        this.client = httpClientImpl;
        this.wrapper = new EngineWrapper(socketChannel, this.engine);
        this.sslParameters = this.engine.getSSLParameters();
        this.serverName = string;
    }

    SSLDelegate(SocketChannel socketChannel, HttpClientImpl httpClientImpl, String[] stringArray, String string) throws IOException {
        this.serverName = string;
        SSLContext sSLContext = httpClientImpl.sslContext();
        this.engine = sSLContext.createSSLEngine();
        this.engine.setUseClientMode(true);
        SSLParameters sSLParameters = httpClientImpl.sslParameters().orElseGet(sSLContext::getSupportedSSLParameters);
        this.sslParameters = Utils.copySSLParameters(sSLParameters);
        if (string != null) {
            SNIHostName sNIHostName = new SNIHostName(string);
            this.sslParameters.setServerNames(Utils8.listOf(sNIHostName));
        }
        if (stringArray != null) {
            Log.logSSL("SSLDelegate: Setting application protocols: {0}" + Arrays.toString(stringArray), new Object[0]);
        } else {
            Log.logSSL("SSLDelegate: No application protocols proposed", new Object[0]);
        }
        this.engine.setSSLParameters(this.sslParameters);
        this.wrapper = new EngineWrapper(socketChannel, this.engine);
        this.chan = socketChannel;
        this.client = httpClientImpl;
    }

    SSLParameters getSSLParameters() {
        return this.sslParameters;
    }

    private static long countBytes(ByteBuffer[] byteBufferArray, int n, int n2) {
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            l += (long)byteBufferArray[n + i].remaining();
        }
        return l;
    }

    ByteBuffer allocate(BufType bufType) {
        return this.allocate(bufType, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer allocate(BufType bufType, int n) {
        assert (this.engine != null);
        SSLDelegate sSLDelegate = this;
        synchronized (sSLDelegate) {
            int n2;
            if (bufType == BufType.PACKET) {
                if (this.packet_buf_size == 0) {
                    SSLSession sSLSession = this.engine.getSession();
                    this.packet_buf_size = sSLSession.getPacketBufferSize();
                }
                if (n > this.packet_buf_size) {
                    this.packet_buf_size = n;
                }
                n2 = this.packet_buf_size;
            } else {
                if (this.app_buf_size == 0) {
                    SSLSession sSLSession = this.engine.getSession();
                    this.app_buf_size = sSLSession.getApplicationBufferSize();
                }
                if (n > this.app_buf_size) {
                    this.app_buf_size = n;
                }
                n2 = this.app_buf_size;
            }
            return ByteBuffer.allocate(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer realloc(ByteBuffer byteBuffer, boolean bl, BufType bufType) {
        SSLDelegate sSLDelegate = this;
        synchronized (sSLDelegate) {
            int n = 2 * byteBuffer.capacity();
            ByteBuffer byteBuffer2 = this.allocate(bufType, n);
            if (bl) {
                byteBuffer.flip();
            }
            byteBuffer2.put(byteBuffer);
            byteBuffer = byteBuffer2;
        }
        return byteBuffer;
    }

    WrapperResult sendData(ByteBuffer byteBuffer) throws IOException {
        ByteBuffer[] byteBufferArray = new ByteBuffer[]{byteBuffer};
        return this.sendData(byteBufferArray, 0, 1);
    }

    WrapperResult sendData(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        WrapperResult wrapperResult = WrapperResult.createOK();
        while (SSLDelegate.countBytes(byteBufferArray, n, n2) > 0L) {
            wrapperResult = this.wrapper.wrapAndSend(byteBufferArray, n, n2, false);
            SSLEngineResult.Status status = wrapperResult.result.getStatus();
            if (status == SSLEngineResult.Status.CLOSED) {
                this.doClosure();
                return wrapperResult;
            }
            SSLEngineResult.HandshakeStatus handshakeStatus = wrapperResult.result.getHandshakeStatus();
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED || handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
            this.doHandshake(handshakeStatus);
        }
        return wrapperResult;
    }

    WrapperResult recvData(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.position();
        WrapperResult wrapperResult = null;
        int n2 = byteBuffer.position();
        while (byteBuffer.position() == n2) {
            wrapperResult = this.wrapper.recvAndUnwrap(byteBuffer);
            byteBuffer = wrapperResult.buf != byteBuffer ? wrapperResult.buf : byteBuffer;
            SSLEngineResult.Status status = wrapperResult.result.getStatus();
            if (status == SSLEngineResult.Status.CLOSED) {
                this.doClosure();
                return wrapperResult;
            }
            SSLEngineResult.HandshakeStatus handshakeStatus = wrapperResult.result.getHandshakeStatus();
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED || handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
            this.doHandshake(handshakeStatus);
        }
        Utils.flipToMark(byteBuffer, n);
        return wrapperResult;
    }

    void doClosure() throws IOException {
        try {
            WrapperResult wrapperResult;
            this.handshaking.lock();
            ByteBuffer byteBuffer = this.allocate(BufType.APPLICATION);
            do {
                byteBuffer.clear();
                byteBuffer.flip();
                wrapperResult = this.wrapper.wrapAndSend(byteBuffer, true);
            } while (wrapperResult.result.getStatus() != SSLEngineResult.Status.CLOSED);
        }
        finally {
            this.handshaking.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doHandshake(SSLEngineResult.HandshakeStatus handshakeStatus) throws IOException {
        boolean bl = false;
        try {
            bl = this.chan.isBlocking();
            this.handshaking.lock();
            this.chan.configureBlocking(true);
            ByteBuffer byteBuffer = this.allocate(BufType.APPLICATION);
            while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                WrapperResult wrapperResult = null;
                switch (handshakeStatus) {
                    case NEED_TASK: {
                        Runnable runnable;
                        while ((runnable = this.engine.getDelegatedTask()) != null) {
                            runnable.run();
                        }
                    }
                    case NEED_WRAP: {
                        byteBuffer.clear();
                        byteBuffer.flip();
                        wrapperResult = this.wrapper.wrapAndSend(byteBuffer, false);
                        break;
                    }
                    case NEED_UNWRAP: {
                        byteBuffer.clear();
                        wrapperResult = this.wrapper.recvAndUnwrap(byteBuffer);
                        if (wrapperResult.buf != byteBuffer) {
                            byteBuffer = wrapperResult.buf;
                        }
                        assert (byteBuffer.position() == 0);
                        break;
                    }
                }
                handshakeStatus = wrapperResult.result.getHandshakeStatus();
            }
            Log.logSSL(this.getSessionInfo(), new Object[0]);
            if (!bl) {
                this.chan.configureBlocking(false);
            }
        }
        finally {
            this.handshaking.unlock();
        }
    }

    static void printParams(SSLParameters sSLParameters) {
        System.out.println("SSLParameters:");
        if (sSLParameters == null) {
            System.out.println("Null params");
            return;
        }
        for (String string : sSLParameters.getCipherSuites()) {
            System.out.printf("cipher: %s\n", string);
        }
        for (String string : sSLParameters.getProtocols()) {
            System.out.printf("protocol: %s\n", string);
        }
        if (sSLParameters.getServerNames() != null) {
            for (SNIServerName sNIServerName : sSLParameters.getServerNames()) {
                System.out.printf("server name: %s\n", sNIServerName.toString());
            }
        }
    }

    String getSessionInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "h2";
        SSLSession sSLSession = this.engine.getSession();
        String string2 = sSLSession.getCipherSuite();
        String string3 = sSLSession.getProtocol();
        stringBuilder.append("Handshake complete alpn: ").append(string).append(", Cipher: ").append(string2).append(", Protocol: ").append(string3);
        return stringBuilder.toString();
    }

    class EngineWrapper {
        SocketChannel chan;
        SSLEngine engine;
        Object wrapLock;
        Object unwrapLock;
        ByteBuffer unwrap_src;
        ByteBuffer wrap_dst;
        boolean closed = false;
        int u_remaining;

        EngineWrapper(SocketChannel socketChannel, SSLEngine sSLEngine) {
            this.chan = socketChannel;
            this.engine = sSLEngine;
            this.wrapLock = new Object();
            this.unwrapLock = new Object();
            this.unwrap_src = SSLDelegate.this.allocate(BufType.PACKET);
            this.wrap_dst = SSLDelegate.this.allocate(BufType.PACKET);
        }

        void close() throws IOException {
        }

        WrapperResult wrapAndSend(ByteBuffer byteBuffer, boolean bl) throws IOException {
            ByteBuffer[] byteBufferArray = new ByteBuffer[]{byteBuffer};
            return this.wrapAndSend(byteBufferArray, 0, 1, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WrapperResult wrapAndSend(ByteBuffer[] byteBufferArray, int n, int n2, boolean bl) throws IOException {
            if (this.closed && !bl) {
                throw new IOException("Engine is closed");
            }
            WrapperResult wrapperResult = new WrapperResult();
            Object object = this.wrapLock;
            synchronized (object) {
                SSLEngineResult.Status status;
                this.wrap_dst.clear();
                do {
                    wrapperResult.result = this.engine.wrap(byteBufferArray, n, n2, this.wrap_dst);
                    status = wrapperResult.result.getStatus();
                    if (status != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
                    this.wrap_dst = SSLDelegate.this.realloc(this.wrap_dst, true, BufType.PACKET);
                } while (status == SSLEngineResult.Status.BUFFER_OVERFLOW);
                if (status == SSLEngineResult.Status.CLOSED && !bl) {
                    this.closed = true;
                    return wrapperResult;
                }
                if (wrapperResult.result.bytesProduced() > 0) {
                    int n3;
                    this.wrap_dst.flip();
                    assert (n3 == wrapperResult.result.bytesProduced());
                    for (n3 = this.wrap_dst.remaining(); n3 > 0; n3 -= this.chan.write(this.wrap_dst)) {
                    }
                }
            }
            return wrapperResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WrapperResult recvAndUnwrap(ByteBuffer byteBuffer) throws IOException {
            boolean bl;
            WrapperResult wrapperResult = new WrapperResult();
            wrapperResult.buf = byteBuffer;
            if (this.closed) {
                throw new IOException("Engine is closed");
            }
            if (this.u_remaining > 0) {
                this.unwrap_src.compact();
                this.unwrap_src.flip();
                bl = false;
            } else {
                this.unwrap_src.clear();
                bl = true;
            }
            Object object = this.unwrapLock;
            synchronized (object) {
                SSLEngineResult.Status status;
                do {
                    if (bl) {
                        int n = this.chan.read(this.unwrap_src);
                        if (n == -1) {
                            throw new IOException("connection closed for reading");
                        }
                        this.unwrap_src.flip();
                    }
                    wrapperResult.result = this.engine.unwrap(this.unwrap_src, wrapperResult.buf);
                    status = wrapperResult.result.getStatus();
                    if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        if (this.unwrap_src.limit() == this.unwrap_src.capacity()) {
                            this.unwrap_src = SSLDelegate.this.realloc(this.unwrap_src, false, BufType.PACKET);
                        } else {
                            this.unwrap_src.position(this.unwrap_src.limit());
                            this.unwrap_src.limit(this.unwrap_src.capacity());
                        }
                        bl = true;
                        continue;
                    }
                    if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        wrapperResult.buf = SSLDelegate.this.realloc(wrapperResult.buf, true, BufType.APPLICATION);
                        bl = false;
                        continue;
                    }
                    if (status != SSLEngineResult.Status.CLOSED) continue;
                    this.closed = true;
                    wrapperResult.buf.flip();
                    return wrapperResult;
                } while (status != SSLEngineResult.Status.OK);
            }
            this.u_remaining = this.unwrap_src.remaining();
            return wrapperResult;
        }
    }

    static enum BufType {
        PACKET,
        APPLICATION;

    }

    static class WrapperResult {
        SSLEngineResult result;
        ByteBuffer buf;

        WrapperResult() {
        }

        static WrapperResult createOK() {
            WrapperResult wrapperResult = new WrapperResult();
            wrapperResult.buf = null;
            wrapperResult.result = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
            return wrapperResult;
        }
    }
}

