/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.Executor;
import sun.misc.InnocuousThread;

class ExecutorWrapper {
    final Executor userExecutor;
    final Executor executor;
    final AccessControlContext acc;
    final ClassLoader ccl;

    public ExecutorWrapper(Executor executor, AccessControlContext accessControlContext) {
        this.userExecutor = executor;
        this.acc = accessControlContext;
        this.ccl = this.getCCL();
        this.executor = System.getSecurityManager() == null ? executor : this::run;
    }

    private ClassLoader getCCL() {
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    private void prepareThread() {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof InnocuousThread)) {
            return;
        }
        InnocuousThread innocuousThread = (InnocuousThread)thread;
        AccessController.doPrivileged(() -> {
            innocuousThread.setContextClassLoader(this.ccl);
            innocuousThread.eraseThreadLocals();
            return null;
        });
    }

    void run(Runnable runnable) {
        this.prepareThread();
        try {
            this.userExecutor.execute(runnable);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public Executor userExecutor() {
        return this.userExecutor;
    }

    public Executor executor() {
        return this.executor;
    }
}

