/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.internet.MimeBodyPart;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>removeHeader()</strong> API.
 * It does by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *		Remove all headers with name. <p>
 * api2test: public void removeHeader(String name)  <p>
 *
 * how2test: Call API with different header names. If this operation is
 *	     successfull then testcase passes otherwise it fails.
 */

public class removeHeader_Test extends MailTest {

    public static String name1 = "Subject";
    public static String value1 = "Testing addHeader() APIs";
    public static String name2 = "Nonsense";
    public static String value2 = "This~!@9#0$is%^2&*1+a=?>.<,:;test";
    public static String name3 = "EmptyField";
    public static String value3 = "";

    public static void main( String argv[] )
    {
        removeHeader_Test test = new removeHeader_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class MimeBodyPart: removeHeader(String)\n");

        try {
	   // Create MimeBodyPart object
	      MimeBodyPart mbp = new MimeBodyPart();

	      if( mbp == null )
		  return Status.failed("Failed to create a MimeBodyPart object");

	   // BEGIN UNIT TEST 1:
	      out.println("UNIT TEST 1: removeHeader("+name1+")");

	      mbp.addHeader(name1, value1);
	      mbp.removeHeader(name1);		// API TEST

	      out.println("UNIT TEST 1: passed\n");
	   // END UNIT TEST 1:
           // BEGIN UNIT TEST 2:
              out.println("UNIT TEST 2: removeHeader("+name2+")");

              mbp.addHeader(name2, value2);
	      mbp.removeHeader(name2);		// API TEST

              out.println("UNIT TEST 2: passed\n");
           // END UNIT TEST 2:
           // BEGIN UNIT TEST 3:
              out.println("UNIT TEST 3: removeHeader("+name3+")");

              mbp.addHeader(name3, value3);
	      mbp.removeHeader(name3);		// API TEST

              out.println("UNIT TEST 3: passed\n");
           // END UNIT TEST 3:

              checkStatus();
        } catch ( Exception e ) {
	      handlException(e);
        }
	return status;
     }
}
