/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.internet.InternetAddress;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>setAddress()</strong> API.
 * It does by invoking the test API and then checking
 * the type of the returned object.	<p>
 *
 *		set the email address  <p>
 * api2test: public void setAddress(String)  <p>
 *
 * how2test: Invoke the setAddress() API, then call getAddress(), if the get value is the
 *	     same the set value, then testcase passes otherwise it fails.
 */

public class setAddress_Test extends MailTest {

    public static void main ( String argv[] )
    {
        setAddress_Test test = new setAddress_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class InternetAddress: setAddress(String)\n");

        try {
          // Connect to host server
             Store store = connect2host(protocol, host, user, password);

          // Get a Folder object
	     Folder root = getRootFolder(store);
             Folder folder = root.getFolder(mailbox);

             if( folder == null ) {
                 return Status.failed("Invalid folder object!");
             }
	     folder.open(Folder.READ_ONLY);

	     if( msgcount == -1 ) {
                 msgcount = folder.getMessageCount();
                 if( msgcount < 1 )
                     return Status.failed("Mail folder is empty!");
             }
          // BEGIN UNIT TEST:
	     
	     for( int i = 1; i <= msgcount; i++ )
	     {
	     // Get a Message object
		Message msg = folder.getMessage(i);

		if( msg == null ) {
                    log.println("WARNING: FAILED TO GET MESSAGE NUMBER: "+ i);
                    continue;
		}
		// Get a From address object(s)
		Address[] addrs = msg.getFrom();

		if( addrs == null ) {
                    log.println("WARNING: FAILED TO GET FROM ADDRESS FOR MESSAGE NUMBER: "+ i);
                    continue;
		}
		// Convert From address object to a string
		String addstr = addrs[0].toString();

		if( addstr != null ) {
		    // create new internet address object
		    InternetAddress addr = new InternetAddress();

		    addr.setAddress(addstr);	// API TEST
		    String strname = addr.getAddress();
		    
		    if ( strname != null ) {
			 if ( strname.equals(addstr) ) {
			      out.println("Address = "+ strname);
			      out.println("UNIT TEST "+ i +": passed\n");
			 } else {
				out.println("UNIT TEST "+ i +": FAILED\n");
				errors++;
			  }
		    }
		} else
		      continue;
	     }
          // END UNIT TEST:
	     folder.close(false);
	     store.close();
	     checkStatus();

        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
