/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Folder;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import javax.activation.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>delete(boolean)</strong> API.
 * It does this by passing various valid input values and then checking the type
 * of the returned object.  <p>
 *
 *		Delete this Folder. <p>
 * api2test: public boolean delete(boolean recurse)  <p>
 *
 * how2test: Call this API. Check the value of boolean object returned,
 *	     if its TRUE then test passes otherwise it fails. <p>
 *
 *	  a) This method will succeed only on a closed Folder.  <p>
 *
 *	     The recurse flag controls whether the deletion affects subfolders or not. <p>
 *	  b) if true, all subfolders are deleted, then this folder itself is deleted.  <p>
 *	  c) if false, the behaviour is dependent on the folder type. See javdoc info. <p>
 *
 *   status: returns a JCK status object.
 */

public class delete_Test extends MailTest {

    public static void main( String argv[] )
    {
        delete_Test test = new delete_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	this.parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Folder: delete(boolean)\n");

        try {
          // Connect to host server
             Store store = this.connect2host(protocol, host, user, password);

          // Get a Folder object
	     Folder root = getRootFolder(store);
	     Folder f1 = root.getFolder(testbox);

	     if( f1 == null ) {
                 return Status.failed("Invalid folder object!");
             }
          // BEGIN UNIT TEST 1:

	     out.println("UNIT TEST 1: delete(false)\n");

	     if ( !(f1.exists()) ) {
		  boolean return_code = f1.create(Folder.HOLDS_MESSAGES);
		  if ( return_code ) {

		       f1.delete(false);		// API TEST

		       if ( !(f1.exists()) )
			    out.println("UNIT TEST 1: passed\n");
		       else {
			     out.println("Failed to delete folder " + testbox);
			     out.println("UNIT TEST 1: FAILED\n");
			     errors++;
		  	}
		  }
	     }
	     store.close();

	  // END OF UNIT TEST 1:
	  // BEGIN UNIT TEST 2:
	     // Get another Session/Store object
	     session = Session.getInstance(properties, null);
	     session.setDebug(debug);
	     store = session.getStore(protocol);

             // Connect
             if( host != null || user != null || password != null)
		 if (portnum > 0)
		     store.connect(host, portnum, user, password);
		 else
		     store.connect(host, user, password);
             else
                 store.connect();

	     // Get a test folder
	     Folder root2 = getRootFolder(store);

	     String testbox = "topdog";
             Folder f2 = root2.getFolder(testbox);

             if( f2 == null ) {
                 return Status.failed("Invalid testfolder object!");
             }

	     if( f2.exists() )
		 f2.delete(true);

	     if(!(f2.create(Folder.HOLDS_FOLDERS))) {
		return Status.failed("Failed to create "+testbox+" folder");
	     }

	     // Get another test folder
	     testbox = "tomcat";
             Folder f3 = f2.getFolder("tomcat");

             if( f3.create(Folder.HOLDS_MESSAGES) )
	     {
		 out.println("UNIT TEST 2: delete(true)\n");

	         f2.delete(true);    // API TEST

		 if( !(f2.exists()) )
		     out.println("UNIT TEST 2: passed\n");
		 else {
                        out.println("Failed to create directory "+testbox+" folder(s)");
                        out.println("UNIT TEST 2: FAILED\n");
                        errors++;
                 }
             }
          // END OF UNIT TEST 2:

	     store.close();
	     this.checkStatus();

        } catch ( Exception e ) {
                this.handlException(e);
        }
	return status;
     }
}
