
/*
 * Copyright (c) 2002-2017 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Flags;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>clearSystemFlags and clearUserFlags</strong> APIs.
 *
 *		Clear the specified flags from this Flags object.<p>
 * api2test: public void clearSystemFlags() <p>
 * api2test: public void clearUserFlags() <p>
 *
 * how2test: First add system and user flags to a Flags object.
 *	     Now clear the flags and check that only the expected flags
 *	     have been removed.
 */

public class clear_Test extends MailTest {

    public static void main( String argv[] )
    {
        clear_Test test = new clear_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Flags: clear{System,User}Flags)\n");

        try {
	  // BEGIN UNIT TEST 1:
	     out.println("\nUNIT TEST 1:  clearSystemFlags()");

	     Flags flag1 = new Flags();
	     flag1.add(Flags.Flag.SEEN);
	     flag1.add("FLAG");
	     flag1.clearSystemFlags();
	     if (!flag1.contains(Flags.Flag.SEEN) && flag1.contains("FLAG")) {
		out.println("UNIT TEST 1: passed\n");
	     } else {
		out.println("UNIT TEST 1: FAILED\n");
		errors++;
	     }
	  // END UNIT TEST 1:
          // BEGIN UNIT TEST 2:

             out.println("\nUNIT TEST 2: clearUserFlags()");

	     Flags flag2 = new Flags();
	     flag2.add(Flags.Flag.SEEN);
	     flag2.add("FLAG");
	     flag2.clearUserFlags();
	     if (flag2.contains(Flags.Flag.SEEN) && !flag2.contains("FLAG")) {
		out.println("UNIT TEST 2: passed\n");
	     } else {
		out.println("UNIT TEST 2: FAILED\n");
		errors++;
	     }
          // END UNIT TEST 2:

	     checkStatus();

        } catch ( Exception e ) {
             handlException(e);
        }
	return status;
     }
}
