/*
 * Copyright (c)  2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 */
package com.sun.ts.tests.jaspic.tssv.module.servlet;

import java.util.logging.Level;

import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpServletResponse;

import com.sun.ts.tests.jaspic.tssv.util.JASPICData;
import com.sun.ts.tests.jaspic.tssv.util.TSLogger;

public class TSResponseWrapper  extends HttpServletResponseWrapper{
	private TSLogger logger = null;

	public TSResponseWrapper(HttpServletResponse response) {
		super(response);
		logger = TSLogger.getTSLogger(JASPICData.LOGGER_NAME);
		logMsg("TSResponseWrapper constructor called");
	}

	@Override
	public String getHeader(String name) {

		if ("isResponseWrapped".equals(name)) {
			return "true";
		}

		return super.getHeader(name);
	}
	
    public void logMsg(String str) {
        if (logger != null){
            logger.log(Level.INFO, str);
        } else {
            System.out.println("*** TSLogger Not Initialized properly ***");
            System.out.println("*** TSSVLogMessage : ***"+str);
        }  
    }

}
