/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.implementation.sun.javaee.glassfish;

import com.sun.ts.lib.deliverable.DeliverableFactory;
import com.sun.ts.lib.deliverable.PropertyManagerInterface;
import com.sun.ts.lib.implementation.sun.javaee.glassfish.AutoDeployment;
import com.sun.ts.lib.implementation.sun.javaee.glassfish.AutoDeploymentServerInterface;
import com.sun.ts.lib.porting.DeploymentInfo;
import com.sun.ts.lib.porting.TSDeployment;
import com.sun.ts.lib.porting.TSDeploymentException;
import com.sun.ts.lib.util.TestUtil;
import java.io.PrintWriter;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.Properties;

public class AutoDeploymentServer
extends UnicastRemoteObject
implements AutoDeploymentServerInterface {
    private static AutoDeploymentServer deploymentServer = null;
    private PropertyManagerInterface propMgr = null;
    private static String sPort = "2002";
    private static int iPort = 2002;
    private AutoDeployment standardDeploy = null;

    public static void main(String[] args) {
        if (args.length == 2 && args[0].equalsIgnoreCase("-port")) {
            sPort = args[1];
        }
        System.setSecurityManager(new RMISecurityManager());
        try {
            deploymentServer = new AutoDeploymentServer();
            iPort = Integer.parseInt(sPort);
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Registry registry = LocateRegistry.createRegistry(iPort);
            TestUtil.logHarness((String)("AutoDeploymentServer:  Registry has been created on port:  " + iPort));
            registry.rebind("AutoDeploymentServer", deploymentServer);
            TestUtil.logHarness((String)"AutoDeploymentServer:  deploymentServer has been bound to the Registry");
        }
        catch (Exception e) {
            TestUtil.logHarness((String)"Failed to bind deploymentServer");
            e.printStackTrace();
        }
    }

    @Override
    public void init(Properties jteProps, Map extraParameters) throws RemoteException {
        try {
            TestUtil.logHarnessDebug((String)"AutoDeploymentServer:  in init");
            jteProps.setProperty("s1as.targets", "server");
            this.propMgr = DeliverableFactory.getDeliverableInstance().createPropertyManager(jteProps);
            if (this.standardDeploy == null) {
                this.standardDeploy = new AutoDeployment();
            }
            Integer portingSetInteger = (Integer)extraParameters.get("porting_set");
            TestUtil.logHarness((String)("AutoDeploymentServer:  iPortingSet = " + portingSetInteger));
            TSDeployment.iPortingSet = portingSetInteger;
            this.standardDeploy.init(new PrintWriter(System.out));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TestUtil.logHarnessDebug((String)"AutoDeploymentServer:  leaving init");
    }

    @Override
    public String deploy(DeploymentInfo info) throws RemoteException {
        try {
            return this.standardDeploy.deploy(info);
        }
        catch (TSDeploymentException e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage(), e);
        }
    }
}

