/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.servlets;

import com.sun.javatest.ExcludeList;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExcludeBrowser
extends HttpServlet {
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ExcludeList excludeList;
        String string = httpServletRequest.getRequestURI();
        File file = new File(httpServletRequest.getRealPath(string));
        if (!file.exists()) {
            httpServletResponse.sendError(404);
            return;
        }
        try {
            excludeList = new ExcludeList(file);
        }
        catch (ExcludeList.Fault fault) {
            String string2 = "The file does not appear to be a valid exclude-list file. The following exception was received while trying to open it: " + fault.toString();
            httpServletResponse.sendError(404, string2);
            return;
        }
        catch (IOException iOException) {
            String string3 = "The file does not appear to be a valid exclude-list file. The following exception was received while trying to open it: " + iOException.toString();
            httpServletResponse.sendError(404, string3);
            return;
        }
        String string4 = this.getInitParameter("bugLink");
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = new PrintWriter((OutputStream)httpServletResponse.getOutputStream());
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<title>" + file + "</title>");
        printWriter.println("</head>");
        printWriter.println("<body>");
        if (excludeList.size() == 0) {
            printWriter.println("Exclude list is empty.");
        } else {
            printWriter.println("<table border=1>");
            Iterator iterator = excludeList.getIterator(false);
            while (iterator.hasNext()) {
                ExcludeList.Entry entry = (ExcludeList.Entry)iterator.next();
                String[] stringArray = entry.getBugIdStrings();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(" ");
                    }
                    String string5 = stringArray[i];
                    if (string4 == null) {
                        stringBuffer.append(string5);
                        continue;
                    }
                    stringBuffer.append("<a href=\"" + string4 + string5 + "\">" + string5 + "</a>");
                }
                printWriter.print("<tr>");
                printWriter.print("<td>" + entry.getRelativeURL());
                if (entry.getTestCases() != null) {
                    printWriter.print("[" + entry.getTestCases() + "]");
                }
                printWriter.print("<td>" + stringBuffer);
                printWriter.print("<td>" + StringArray.join(entry.getPlatforms()));
                printWriter.print("<td>" + entry.getSynopsis());
                printWriter.println();
            }
            printWriter.println("</table>");
        }
        printWriter.println("<p><hr>");
        printWriter.println("File: <em>" + file + "</em>");
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
    }
}

