/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.URLDataSource;

import  java.net.*;
import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 

// Calls the getFile method on the URL used to instantiate the object.

/**
 * Create an instance of URLDataSource, then use it to call getName() method, if it
 * returns a non-null expected string, then this testcase passes, otherwise it fails. <p>
 */

public class getName_Test extends MultiTest
{
private static final String httpURLSpec = "http://www.sun.com/index.html";
private static final String badURLSpec = "http://www.nonexistentdomain.com";

public static void main(String argv[])
{
	getName_Test lTest = new getName_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status getName_Test() throws IOException, MalformedURLException
{
	URL goodURL  = new URL(httpURLSpec);
	URLDataSource gds = new URLDataSource(goodURL);

	if (!goodURL.equals(gds.getURL()))
		return Status.failed("Failed: getURL didn't match initializer");

	String urlName = goodURL.getFile();
	String dsName = gds.getName();		// API TEST

	if (urlName == null) {
	    if (dsName != null)
		return Status.failed("Failed: getName() != URL.getFile()");
	} else if (!urlName.equals(dsName)){
	    	   return Status.failed("Failed: getName() != URL.getFile()");
	}

	URL badURL = new URL(badURLSpec);
	URLDataSource bds = new URLDataSource(badURL);

	if (!badURL.equals(bds.getURL()))
		return Status.failed("Failed: bad url, getURL didn't match initializer");

	urlName = badURL.getFile();
	dsName = bds.getName();   	// API TEST

	if (urlName == null) {
	    if (dsName != null)
		return Status.failed("Failed: getName() != URL.getFile()");
	} else if (!urlName.equals(dsName)){
	    	   return Status.failed("Failed: getName() != URL.getFile()");
	}

	return Status.passed("getName() test succeeded");
}

}
