/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.MimeType;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import	com.sun.javatest.lib.MultiTest; 

/**
 * Create a MimeType instance, use it to call toString() method,
 * if it successfully returns non-null string representation of this
 * object, then this test passes otherwise it fails. <p> 
 */

public class toString_Test extends MultiTest
{
public static void main(String argv[])
{
	toString_Test lTest = new toString_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status toStringTest1()
{	
	try {
		MimeType objmt =  new MimeType("text/plain");
		if( objmt == null )
		    return Status.failed("Failed: to create MimeType object using constructor");

                String tostr =  objmt.toString();       // API TEST

                if( tostr == null )
                    return Status.failed("Failed: toString() returned null string!");
 
	} catch(Exception ex) {
		return Status.failed("toString() threw " + ex.toString());
	}

	return Status.passed("toString(void) test succeeded");
}

public Status toStringTest2()
{
        try {
                MimeType objmt =  new MimeType();
                if( objmt == null )
                    return Status.failed("Failed: to create MimeType object using constructor");

                String tostr =  objmt.toString();       // API TEST

                if( tostr == null )
                    return Status.failed("Failed: toString() returned null string!");

        } catch(Exception ex) {
                return Status.failed("toString() threw " + ex.toString());
        }

        return Status.passed("toString(void) test succeeded");
}

}
