/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.MimeType;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import	com.sun.javatest.lib.MultiTest; 

/**
 * Create a MimeType instance, use it to call getPrimaryType() method, if it
 * returns a primary (string) type of this object, then this test passes,
 * otherwise it fails. <p>
 */

public class getPrimaryType_Test extends MultiTest
{
public static void main(String argv[])
{
	getPrimaryType_Test lTest = new getPrimaryType_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status	getPrimaryTypeTest1()
{	
	try {
		MimeType objmt =  new MimeType("text/plain");
		if( objmt == null )
		    return Status.failed("Failed: to create MimeType object using constructor");

                String primetype =  objmt.getPrimaryType();       // API TEST

                if( primetype == null )
                    return Status.failed("Failed: getPrimaryType() returned null string!");
 
	} catch(Exception ex) {
		return Status.failed("getPrimaryType() threw " + ex.toString());
	}

	return Status.passed("getPrimaryType(void) test succeeded");
}

public Status   getPrimaryTypeTest2()
{
        try {
                MimeType objmt =  new MimeType();
                if( objmt == null )
                    return Status.failed("Failed: to create MimeType object using constructor");

                String primetype =  objmt.getPrimaryType();       // API TEST

                if( primetype != null )
                    return Status.passed("getPrimaryType() test succeeded");

        } catch(Exception ex) {
                return Status.failed("getPrimaryType() threw " + ex.toString());
        }

        return Status.failed("getPrimaryType(void) test failed");
}

}
