/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.MimeType;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import	com.sun.javatest.lib.MultiTest; 

/**
 * Create a MimeType instance, use it to call getBaseType() method, if
 * it returns a string representation of this object, then this test
 * passes, otherwise it fails. <p>
 */

public class getBaseType_Test extends MultiTest
{

public static void main(String argv[])
{
	getBaseType_Test lTest = new getBaseType_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status	getBaseTypeTest()
{	
	try {
		MimeType objmt =  new MimeType("text/plain");

		if( objmt == null )
		    return Status.failed("Failed: to create MimeType object using constructor");

                String basetype =  objmt.getBaseType();       // API TEST

                if( basetype == null )
                    return Status.failed("Failed: getBaseType() returned null string!");
 
	}catch(Exception ex) {
		return Status.failed("MimeType(String) threw " + ex.toString());
	}

	return Status.passed("getBaseType(void) test succeeded");
}

}
