/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.FileTypeMap;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import	javasoft.sqe.tests.api.javax.activation.TestClasses.TestFileTypeMap;

// FileTypeMap is an abstract class. The main functional testing is in the only provided
// concrete implementation, MimetypesFileTypeMap, tested separately.  Here we just test
// the default constructor.

/** FileTypeMap is an abstract class. The main functional testing is in the only provided
 *  concrete implementation, MimetypesFileTypeMap, tested separately.<p>  
 *  Get object of type FileTypeMap, by calling getDefaultFileTypeMap() api, 
 *  If this method returns a non-null object of type FileTypeMap then this
 *  testcase passes, otherwise it fails. <p>
 */

public class FileTypeMap_Test implements Test
{

public static void main(String argv[])
{
	FileTypeMap_Test lTest = new FileTypeMap_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status run(String argv[], PrintWriter outLog, PrintWriter outConsole)
{
	FileTypeMap ftm = FileTypeMap.getDefaultFileTypeMap();	// API TEST

	if( ftm == null )
	    return Status.failed("FileTypeMap() returned null");

	return Status.passed("FileTypeMap() test succeeded");
}

}
