/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.CommandMap;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import	javasoft.sqe.tests.api.javax.activation.TestClasses.*;

/** CommandMap is an abstract class. The main functional testing is in the only
 *  provided concrete implementation, MailcapCommandMap, done separately. <p>
 *  We get default CommandMap objedct then using it call createDataContentHandler()
 *  api with string parameter. If this call returns a non-null DataContentHandler
 *  object then this testcase passes otherwise it fails. <p>
 */

public class createDataContentHandler_Test implements Test
{
	public static void main(String argv[])
	{
		createDataContentHandler_Test lTest = new createDataContentHandler_Test();
		Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
		lStatus.exit();
	}

	public Status run(String argv[], PrintWriter outLog, PrintWriter outConsole)
	{
		// does getDefaultCommandMap return a MailcapCommandMap ?
		CommandMap lCommandMap = CommandMap.getDefaultCommandMap();

		if (!(lCommandMap instanceof MailcapCommandMap))
	    	    return Status.failed("getDefaultCommandMap() did not return MailcapCommandMap");
	
		DataContentHandler dch = lCommandMap.createDataContentHandler("text/plain"); //API TEST

		if( dch == null )
		    return Status.failed("createDataContentHandler failed to return DataContentHandler object!");

		return Status.passed("createDataContentHandler() Test succeeded");
	}
}
